/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.style;

import java.awt.Dimension;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.AbstractTableModel;
import nextapp.echo2.app.table.TableModel;
import nextapp.echo2.app.text.TextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.style.StyleSheets;
import org.openvpms.web.echo.style.UserStyleSheets;
import org.openvpms.web.echo.table.DefaultTableHeaderRenderer;
import org.openvpms.web.echo.table.EvenOddTableCellRenderer;
import org.openvpms.web.echo.table.KeyTable;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.style.ResolutionSelectField;
import org.openvpms.web.workspace.admin.style.StyleHelper;

public class StyleBrowser {
    private ResolutionSelectField resolutionSelector;
    private final SimpleProperty width;
    private final SimpleProperty height;
    private KeyTable propertyTable;
    private final UserStyleSheets styles;
    private Component component;
    private final ModifiableListener resolutionListener;

    public StyleBrowser(UserStyleSheets stylesheets, Dimension size) {
        this.styles = stylesheets;
        this.resolutionListener = new ModifiableListener(){

            public void modified(Modifiable modifiable) {
                StyleBrowser.this.displayResolution();
            }
        };
        this.width = new SimpleProperty("width", (Object)size.width, Integer.class);
        this.width.setDisplayName(Messages.get((String)"stylesheet.width"));
        this.width.addModifiableListener(this.resolutionListener);
        this.height = new SimpleProperty("height", (Object)size.height, Integer.class);
        this.height.setDisplayName(Messages.get((String)"stylesheet.height"));
        this.height.addModifiableListener(this.resolutionListener);
        this.resolutionSelector = this.createResolutionSelector();
        this.resolutionSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StyleBrowser.this.updateWidthAndHeight(StyleBrowser.this.getSelectedResolution());
                StyleBrowser.this.displayResolution();
            }
        });
    }

    public Component getComponent() {
        if (this.component == null) {
            Row row1 = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"stylesheet.resolution"), this.resolutionSelector});
            Row row2 = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.createLabel((Property)this.width), this.createField((Property)this.width), this.createLabel((Property)this.height), this.createField((Property)this.height)});
            Row wrapper = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{row1, row2});
            this.component = ColumnFactory.create((String)"Inset", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{wrapper, this.getTable()})});
        }
        return this.component;
    }

    public Dimension getSelectedResolution() {
        Dimension result = (Dimension)this.resolutionSelector.getSelectedItem();
        return result != null ? result : StyleHelper.ANY_RESOLUTION;
    }

    public void refresh() {
        Dimension size = this.getSelectedResolution();
        this.resolutionSelector.setModel(ResolutionSelectField.createModel(this.getResolutions()));
        if (this.resolutionSelector.contains(size)) {
            this.resolutionSelector.setSelectedItem(size);
        } else {
            this.resolutionSelector.setSelectedIndex(0);
        }
        this.updateWidthAndHeight(size);
        this.displayResolution();
    }

    private void updateWidthAndHeight(Dimension size) {
        if (!StyleHelper.ANY_RESOLUTION.equals(size)) {
            try {
                this.width.removeModifiableListener(this.resolutionListener);
                this.height.removeModifiableListener(this.resolutionListener);
                this.width.setValue((Object)size.width);
                this.height.setValue((Object)size.height);
            }
            finally {
                this.width.addModifiableListener(this.resolutionListener);
                this.height.addModifiableListener(this.resolutionListener);
            }
        }
    }

    private void displayResolution() {
        this.getTable().setModel((TableModel)this.createTableModel());
    }

    private Dimension getEvalResolution() {
        if (this.width.isValid() && this.height.isValid()) {
            return new Dimension((Integer)this.width.getValue(), (Integer)this.height.getValue());
        }
        return new Dimension();
    }

    private Dimension[] getResolutions() {
        return (Dimension[])ArrayUtils.insert((int)0, (Object[])this.styles.getResolutions(), (Object[])new Dimension[]{StyleHelper.ANY_RESOLUTION});
    }

    private Table getTable() {
        if (this.propertyTable == null) {
            PropertyTableModel model = this.createTableModel();
            this.propertyTable = TableFactory.create((TableModel)model);
            this.propertyTable.setDefaultHeaderRenderer(DefaultTableHeaderRenderer.DEFAULT);
            this.propertyTable.setDefaultRenderer(Object.class, EvenOddTableCellRenderer.INSTANCE);
            this.propertyTable.setHeaderFixed(true);
        }
        return this.propertyTable;
    }

    private PropertyTableModel createTableModel() {
        Dimension size = this.getSelectedResolution();
        Dimension evalSize = this.getEvalResolution();
        Map<String, String> properties = StyleHelper.getProperties((StyleSheets)this.styles, size, false);
        Map evaluated = this.styles.evaluate(properties, evalSize.width, evalSize.height);
        return new PropertyTableModel(properties, evaluated);
    }

    private ResolutionSelectField createResolutionSelector() {
        return new ResolutionSelectField(this.getResolutions());
    }

    private Label createLabel(Property property) {
        Label label = LabelFactory.create();
        label.setText(property.getDisplayName());
        return label;
    }

    private TextComponent createField(Property property) {
        return BoundTextComponentFactory.create((Property)property, (int)4);
    }

    private static class PropertyTableModel
    extends AbstractTableModel {
        private final Map<String, String> properties;
        private final Map<String, String> evaluated;
        private String[] columnNames = new String[]{Messages.get((String)"stylesheet.propertyName"), Messages.get((String)"stylesheet.propertyExpression"), Messages.get((String)"stylesheet.propertyValue")};
        private static final int NAME_COLUMN = 0;
        private static final int EXPRESSION_COLUMN = 1;
        private static final int VALUE_COLUMN = 2;

        public PropertyTableModel(Map<String, String> properties, Map<String, String> evaluated) {
            this.properties = properties;
            this.evaluated = evaluated;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.properties.size();
        }

        public Object getValueAt(int column, int row) {
            String result = null;
            String[] keys = this.properties.keySet().toArray(new String[this.properties.keySet().size()]);
            String key = keys[row];
            switch (column) {
                case 0: {
                    result = key;
                    break;
                }
                case 1: {
                    result = this.properties.get(key);
                    break;
                }
                case 2: {
                    result = this.evaluated.get(key);
                }
            }
            return result;
        }
    }
}

