/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.worklist;

import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.ReferenceDataService;
import org.openvpms.smartflow.model.Department;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.PairListModel;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.system.ServiceHelper;

public class WorkListEditor
extends AbstractIMObjectEditor {
    private final FlowSheetServiceFactory flowSheetServiceFactory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);

    public WorkListEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    public IMObjectEditor newInstance() {
        return new WorkListEditor(this.reload(this.getObject()), this.reload(this.getParent()), this.getLayoutContext());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        Property department = this.getProperty("defaultFlowSheetDepartment");
        Property treatment = this.getProperty("defaultFlowSheetTemplate");
        Party location = this.getLayoutContext().getContext().getLocation();
        if (location != null && this.flowSheetServiceFactory.isSmartFlowSheetEnabled(location)) {
            ReferenceDataService service = this.flowSheetServiceFactory.getReferenceDataService(location);
            ComponentState departments = this.getDepartments(department, service);
            ComponentState treatments = this.getTreatments(treatment, service);
            strategy.addComponent(departments);
            strategy.addComponent(treatments);
        } else {
            strategy.addComponent(new ComponentState((Component)LabelFactory.create(), department));
            strategy.addComponent(new ComponentState((Component)LabelFactory.create(), treatment));
        }
        return strategy;
    }

    private ComponentState getDepartments(Property property, ReferenceDataService service) {
        PairListModel model = new PairListModel();
        try {
            for (Department department : service.getDepartments()) {
                model.add((Object)department.getDepartmentId(), (Object)department);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        SelectField field = BoundSelectFieldFactory.create((Property)property, (ListModel)model);
        field.setCellRenderer(PairListModel.RENDERER);
        return new ComponentState((Component)field, property);
    }

    private ComponentState getTreatments(Property property, ReferenceDataService service) {
        List names = Collections.emptyList();
        try {
            names = service.getTreatmentTemplates();
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        SelectField field = BoundSelectFieldFactory.create((Property)property, (ListModel)new DefaultListModel(names.toArray()));
        return new ComponentState((Component)field, property);
    }
}

