/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.practice;

import java.io.InputStream;
import java.util.Date;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.webcontainer.command.BrowserOpenWindowCommand;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.subscription.core.Subscription;
import org.openvpms.subscription.core.SubscriptionFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionViewer {
    private final Component root;
    private final LayoutContext context;
    private DocumentAct act;
    private static final Logger log = LoggerFactory.getLogger(SubscriptionViewer.class);

    public SubscriptionViewer(LayoutContext context) {
        this.context = context;
        this.root = RowFactory.create();
    }

    public void setSubscription(DocumentAct subscription) {
        this.act = subscription;
    }

    public Component getComponent() {
        this.refresh();
        return this.root;
    }

    public void refresh() {
        Document document = this.act != null ? (Document)this.context.getCache().get(this.act.getDocument()) : null;
        Component component = document != null ? this.getSubscription(document) : this.getNoSubscription();
        this.root.removeAll();
        this.root.add(component);
    }

    private Component getNoSubscription() {
        Label noSubscription = LabelFactory.create((String)"subscription.nosubscription");
        Component prompt = this.getSubscribePrompt("subscription.subscribe");
        return ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{noSubscription, prompt});
    }

    private Component getSubscribePrompt(String messageId) {
        Label subscribe = LabelFactory.create((String)messageId);
        Button url = ButtonFactory.create((String)"subscription.url", (String)"hyperlink");
        url.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent e) {
                String link = Messages.get((String)"subscription.url");
                ApplicationInstance.getActive().enqueueCommand((Command)new BrowserOpenWindowCommand(link, null, null));
            }
        });
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{subscribe, url});
    }

    private Component getSubscription(Document document) {
        Object result;
        try {
            DocumentHandler documentHandler = ServiceHelper.getDocumentHandlers().get((org.openvpms.component.model.document.Document)document);
            InputStream content = documentHandler.getContent((org.openvpms.component.model.document.Document)document);
            Subscription subscription = SubscriptionFactory.create((InputStream)content);
            Label organisation = LabelFactory.create();
            Label subscriber = LabelFactory.create();
            Label email = LabelFactory.create();
            Label expiration = LabelFactory.create();
            organisation.setText(subscription.getOrganisationName());
            subscriber.setText(subscription.getSubscriberName());
            email.setText(subscription.getSubscriberEmail());
            Date expiryDate = subscription.getExpiryDate();
            boolean expired = true;
            if (expiryDate != null && DateRules.getDate((Date)expiryDate).compareTo(DateRules.getDate((Date)new Date())) > 0) {
                expired = false;
                expiration.setText(DateFormatter.getFullDateFormat().format(expiryDate));
            }
            Grid grid = GridFactory.create((int)2, (Component[])new Component[]{LabelFactory.create((String)"subscription.organisationName", (String)"bold"), organisation, LabelFactory.create((String)"subscription.subscriberName", (String)"bold"), subscriber, LabelFactory.create((String)"subscription.subscriberEmail", (String)"bold"), email, LabelFactory.create((String)"subscription.expiryDate", (String)"bold"), expiration});
            result = expired ? ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{grid, LabelFactory.create((String)"subscription.expired", (String)"bold"), this.getSubscribePrompt("subscription.renew")}) : grid;
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            result = LabelFactory.create((String)"subscription.invalid");
        }
        return result;
    }
}

