/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.practice;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.subscription.SubscriptionHelper;
import org.openvpms.web.echo.servlet.ServletHelper;
import org.openvpms.web.workspace.admin.organisation.AbstractOrganisationEditor;
import org.openvpms.web.workspace.admin.organisation.practice.PracticeLayoutStrategy;
import org.openvpms.web.workspace.admin.organisation.practice.SubscriptionParticipationEditor;

public class PracticeEditor
extends AbstractOrganisationEditor {
    private final SubscriptionParticipationEditor subscriptionEditor;

    public PracticeEditor(Party practice, IMObject parent, LayoutContext context) {
        super((Entity)practice, parent, context);
        Participation participation = SubscriptionHelper.getSubscriptionParticipation((Party)practice, (IArchetypeService)this.getService());
        if (participation == null) {
            participation = (Participation)IMObjectCreator.create((String)"participation.subscription");
        }
        this.subscriptionEditor = new SubscriptionParticipationEditor(participation, practice, context);
        this.subscriptionEditor.setDeleteAct(true);
        Property baseUrl = this.getProperty("baseUrl");
        if (baseUrl.getString() == null) {
            baseUrl.setValue((Object)ServletHelper.getContextURL());
        }
        this.addEditor((Editor)this.subscriptionEditor);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new PracticeEditorLayoutStrategy();
    }

    private class PracticeEditorLayoutStrategy
    extends PracticeLayoutStrategy {
        public PracticeEditorLayoutStrategy() {
            super(PracticeEditor.this.subscriptionEditor.getComponent(), PracticeEditor.this.subscriptionEditor.getFocusGroup());
        }

        @Override
        protected ComponentState getLogo(IMObject object, LayoutContext context) {
            return this.getLogo(PracticeEditor.this.getLogoEditor());
        }
    }
}

