/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.mail;

import java.util.ArrayList;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.BoundLookupField;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.MutablePropertySet;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetImpl;
import org.openvpms.web.component.property.RequiredProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.security.oauth.OAuth2RequestLauncher;
import org.openvpms.web.security.oauth.OAuth2ResponseManager;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.organisation.mail.AbstractMailSettingsLayoutStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2Error;

public class MailSettingsEditor {
    public static final String SECURITY = "security";
    public static final String AUTHENTICATION_METHOD = "authenticationMethod";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String OAUTH2_CLIENT_REGISTRATION = "oauth2ClientRegistration";
    private final Entity object;
    private final PropertySet properties;
    private final LayoutContext layoutContext;
    private final ComponentState authenticationMethodComponent;
    private final ArchetypeService service;
    private final LookupService lookups;
    private MailSettingsLayoutStrategy layoutStrategy;
    private static final String REGISTRATION_LOOKUP = "lookup.oauth2ClientRegistration";
    private static final String AUTHORISE_ID = "button.authorise";
    private static final String CHECK_AUTHORISATION_ID = "button.checkAuthorisation";
    private static final String EDIT_REGISTRATION_ID = "button.editOAuth2Registration";
    private static final Logger log = LoggerFactory.getLogger(MailSettingsEditor.class);

    public MailSettingsEditor(Entity object, PropertySet properties, LayoutContext layoutContext) {
        this.object = object;
        this.properties = properties;
        this.layoutContext = layoutContext;
        this.service = ServiceHelper.getArchetypeService();
        this.lookups = ServiceHelper.getLookupService();
        Property authenticationMethod = properties.get(AUTHENTICATION_METHOD);
        this.authenticationMethodComponent = layoutContext.getComponentFactory().create(authenticationMethod, (IMObject)object);
        authenticationMethod.addModifiableListener(modifiable -> this.onAuthenticationMethodChanged());
        Property registration = properties.get(OAUTH2_CLIENT_REGISTRATION);
        registration.addModifiableListener(modifiable -> this.setUsername(null));
        properties.get(USERNAME).addModifiableListener(modifiable -> this.onUsernameChanged());
    }

    public String getUsername() {
        return StringUtils.trimToNull((String)this.properties.get(USERNAME).getString());
    }

    public void setUsername(String username) {
        this.properties.get(USERNAME).setValue((Object)StringUtils.trimToNull((String)username));
    }

    public MailServer.AuthenticationMethod getAuthenticationMethod() {
        Property authenticationMethod = this.properties.get(AUTHENTICATION_METHOD);
        String value = authenticationMethod.getString();
        return value != null ? MailServer.AuthenticationMethod.valueOf((String)value) : null;
    }

    public boolean validate(Validator validator) {
        boolean valid = true;
        if (MailServer.AuthenticationMethod.OAUTH2 == this.getAuthenticationMethod() && this.getUsername() == null && this.refreshEmailAddress() != OAuth2Status.SUCCESS) {
            valid = false;
            if (this.getLayoutStrategy().isAuthoriseButtonDisplayed()) {
                validator.add((Modifiable)this.properties.get(AUTHENTICATION_METHOD), Messages.get((String)"admin.mail.oauth2.authorise"));
            } else {
                validator.add((Modifiable)this.properties.get(AUTHENTICATION_METHOD), Messages.get((String)"admin.mail.oauth2.incomplete"));
            }
        }
        return valid;
    }

    public MailSettingsLayoutStrategy getLayoutStrategy() {
        if (this.layoutStrategy == null) {
            this.layoutStrategy = new MailSettingsLayoutStrategy();
        }
        return this.layoutStrategy;
    }

    private void onAuthenticationMethodChanged() {
        if (MailServer.AuthenticationMethod.OAUTH2 == this.getAuthenticationMethod()) {
            this.setUsername(null);
            this.properties.get(PASSWORD).setValue(null);
        }
        this.getLayoutStrategy().addSecuritySettings((IMObject)this.object, this.properties, this.layoutContext);
    }

    private void onUsernameChanged() {
        if (this.getUsername() != null && MailServer.AuthenticationMethod.OAUTH2 == this.getAuthenticationMethod() && !this.getLayoutStrategy().isAuthoriseButtonDisplayed()) {
            this.getLayoutStrategy().showAuthoriseButton();
        }
    }

    private OAuth2Status refreshEmailAddress() {
        OAuth2Status result;
        OAuth2ResponseManager responseManager = (OAuth2ResponseManager)ServiceHelper.getBean(OAuth2ResponseManager.class);
        String email = responseManager.getEmail();
        if (email != null) {
            this.setUsername(email);
            result = OAuth2Status.SUCCESS;
        } else {
            OAuth2Error error = responseManager.getError();
            if (error != null) {
                log.error("OAuth2 authorisation failed: {}, uri={}", (Object)error, (Object)error.getUri());
                ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().title(Messages.get((String)"admin.mail.oauth2.title"))).message(Messages.format((String)"admin.mail.oauth2.error", (Object[])new Object[]{error.toString()}))).button(AUTHORISE_ID, () -> this.onAuthorise(true))).button(EDIT_REGISTRATION_ID, this::editClientRegistration)).cancel()).show();
                result = OAuth2Status.ERROR;
                this.getLayoutStrategy().showAuthoriseButton();
            } else {
                result = OAuth2Status.INCOMPLETE;
            }
        }
        responseManager.clear();
        return result;
    }

    private void editClientRegistration() {
        String clientRegistration = this.properties.get(OAUTH2_CLIENT_REGISTRATION).getString();
        if (clientRegistration != null) {
            this.editClientRegistration(clientRegistration, false);
        }
    }

    private void editClientRegistration(String code, boolean authoriseOnCompletion) {
        Lookup lookup = this.lookups.getLookup(REGISTRATION_LOOKUP, code);
        if (lookup != null) {
            lookup = (Lookup)this.service.get(lookup.getObjectReference(), Lookup.class);
        }
        if (lookup == null) {
            lookup = (Lookup)this.service.create(REGISTRATION_LOOKUP, Lookup.class);
            lookup.setCode(code);
        }
        Context context = this.layoutContext.getContext();
        IMObjectEditor editor = this.layoutContext.getEditorFactory().create((IMObject)lookup, (LayoutContext)new DefaultLayoutContext(true, context, this.layoutContext.getHelpContext()));
        EditDialog dialog = ((EditDialogFactory)ServiceHelper.getBean(EditDialogFactory.class)).create(editor, context);
        if (authoriseOnCompletion) {
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    MailSettingsEditor.this.onAuthorise(false);
                }
            });
        }
        dialog.show();
    }

    private void onAuthorise(boolean confirm) {
        String clientRegistration = this.properties.get(OAUTH2_CLIENT_REGISTRATION).getString();
        if (clientRegistration != null) {
            Lookup lookup = this.lookups.getLookup(REGISTRATION_LOOKUP, clientRegistration);
            if (lookup == null) {
                this.editClientRegistration(clientRegistration, true);
            } else {
                String username = this.getUsername();
                if (username == null || !confirm) {
                    this.launchAuthorisation();
                } else {
                    ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"admin.mail.oauth2.title"))).message(Messages.format((String)"admin.mail.oauth2.reauthorise", (Object[])new Object[]{username}))).yesNo()).yes(this::launchAuthorisation)).show();
                }
            }
        }
    }

    private void launchAuthorisation() {
        this.setUsername(null);
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)this.object);
        String clientRegistrationId = bean.getString(OAUTH2_CLIENT_REGISTRATION);
        this.getLayoutStrategy().showCheckAuthoriseButton();
        OAuth2RequestLauncher launcher = (OAuth2RequestLauncher)ServiceHelper.getBean(OAuth2RequestLauncher.class);
        launcher.launch(clientRegistrationId);
    }

    private void onCheck() {
        OAuth2Status status = this.refreshEmailAddress();
        if (status == OAuth2Status.INCOMPLETE) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"admin.mail.oauth2.title"))).message(Messages.get((String)"admin.mail.oauth2.check"))).button(AUTHORISE_ID, () -> this.onAuthorise(true))).button(CHECK_AUTHORISATION_ID, this::onCheck)).button(EDIT_REGISTRATION_ID, this::editClientRegistration)).buttons(new String[]{"cancel"})).show();
        }
    }

    private static enum OAuth2Status {
        SUCCESS,
        INCOMPLETE,
        ERROR;

    }

    protected class MailSettingsLayoutStrategy
    extends AbstractMailSettingsLayoutStrategy {
        private final Button authButton;
        private boolean authoriseButton;
        private Runnable authAction;
        private FocusGroup settingsFocus;

        public MailSettingsLayoutStrategy() {
            super(true);
            this.authButton = ButtonFactory.create();
            this.authButton.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    if (MailSettingsLayoutStrategy.this.authAction != null) {
                        MailSettingsLayoutStrategy.this.authAction.run();
                    }
                }
            });
        }

        public boolean isAuthoriseButtonDisplayed() {
            return this.authoriseButton;
        }

        public void showAuthoriseButton() {
            this.authoriseButton = true;
            this.changeAuthButton(MailSettingsEditor.AUTHORISE_ID, "admin.mail.oauth.authorise.tooltip", () -> MailSettingsEditor.this.onAuthorise(true));
        }

        public void showCheckAuthoriseButton() {
            this.authoriseButton = false;
            this.changeAuthButton(MailSettingsEditor.CHECK_AUTHORISATION_ID, null, () -> MailSettingsEditor.this.onCheck());
        }

        @Override
        protected void addSecuritySettings(IMObjectTabPaneModel model, IMObject object, PropertySet properties, LayoutContext context) {
            if (model.size() > 0) {
                model.removeTabAt(0);
            }
            FocusGroup group = this.getFocusGroup();
            if (this.settingsFocus != null) {
                group.remove(this.settingsFocus);
            }
            super.addSecuritySettings(model, object, properties, context);
            group.add(this.settingsFocus);
        }

        @Override
        protected Component getSecuritySettings(IMObject object, PropertySet properties, LayoutContext context) {
            PropertySetImpl children;
            ArrayList<Property> list = new ArrayList<Property>();
            this.settingsFocus = new FocusGroup("SecuritySettings");
            list.add(properties.get(MailSettingsEditor.SECURITY));
            list.add(MailSettingsEditor.this.authenticationMethodComponent.getProperty());
            Property username = properties.get(MailSettingsEditor.USERNAME);
            this.removeComponent(MailSettingsEditor.AUTHENTICATION_METHOD);
            if (MailSettingsEditor.this.getAuthenticationMethod() == MailServer.AuthenticationMethod.OAUTH2) {
                ComponentState auth = this.createComponentPair(MailSettingsEditor.this.authenticationMethodComponent, this.createClientRegistration(properties));
                FocusGroup authFocus = auth.getFocusGroup();
                authFocus.add((Component)this.authButton);
                auth = new ComponentState((Component)RowFactory.create((String)"CellSpacing", (Component[])new Component[]{auth.getComponent(), this.authButton}), auth.getProperty(), authFocus);
                this.showAuthoriseButton();
                this.addComponent(auth);
                list.add(username);
                MutablePropertySet set = new MutablePropertySet((PropertySet)new PropertySetImpl(list));
                set.setReadOnly(MailSettingsEditor.USERNAME);
                children = set;
            } else {
                this.addComponent(MailSettingsEditor.this.authenticationMethodComponent);
                list.add(username);
                list.add(properties.get(MailSettingsEditor.PASSWORD));
                children = new PropertySetImpl(list);
            }
            ComponentSet set = this.addComponents(new ComponentSet(this.settingsFocus), object, children.getProperties(), context);
            ComponentGrid grid = new ComponentGrid();
            grid.add(set, 1);
            return grid.createGrid(set);
        }

        private void changeAuthButton(String key, String tooltip, Runnable action) {
            this.authButton.setText(Messages.get((String)key));
            this.authAction = action;
            this.authButton.setToolTipText(tooltip != null ? Messages.get((String)tooltip) : null);
        }

        private ComponentState createClientRegistration(PropertySet properties) {
            Property property = properties.get(MailSettingsEditor.OAUTH2_CLIENT_REGISTRATION);
            NodeLookupQuery query = new NodeLookupQuery(MailSettingsEditor.REGISTRATION_LOOKUP, "code");
            BoundLookupField field = new BoundLookupField((Property)new RequiredProperty(property), (LookupQuery)query);
            field.setStyleName(MailSettingsEditor.this.layoutContext.getComponentFactory().getStyle());
            return new ComponentState((Component)field, property);
        }
    }
}

