/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.mail;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.IMObjectTabPane;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.MutablePropertySet;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetImpl;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.resource.i18n.Messages;

public abstract class AbstractMailSettingsLayoutStrategy
extends AbstractLayoutStrategy {
    private IMObjectTabPane tabs;

    public AbstractMailSettingsLayoutStrategy() {
        this(false);
    }

    public AbstractMailSettingsLayoutStrategy(boolean keepState) {
        super(new ArchetypeNodes().exclude(new String[]{"security", "authenticationMethod", "username", "password", "oauth2ClientRegistration"}), keepState);
    }

    protected void addSecuritySettings(IMObject object, PropertySet properties, LayoutContext context) {
        if (this.tabs != null) {
            IMObjectTabPaneModel model = this.tabs.getModel();
            this.addSecuritySettings(model, object, properties, context);
        }
    }

    protected void addSecuritySettings(IMObjectTabPaneModel model, IMObject object, PropertySet properties, LayoutContext context) {
        model.addTab(Messages.get((String)"admin.mail.securitySettings"), (Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.getSecuritySettings(object, properties, context)}));
    }

    protected void doLayout(IMObject object, PropertySet properties, IMObject parent, Component container, LayoutContext context) {
        super.doLayout(object, properties, parent, container, context);
        this.addSecuritySettings(this.tabs.getModel(), object, properties, context);
    }

    protected void doComplexLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        IMObjectTabPaneModel model = this.doTabLayout(object, properties, container, context, false);
        this.tabs = new IMObjectTabPane(model);
        container.add((Component)this.tabs);
    }

    protected Component getSecuritySettings(IMObject object, PropertySet properties, LayoutContext context) {
        PropertySetImpl children;
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(properties.get("security"));
        Property authenticationMethod = properties.get("authenticationMethod");
        list.add(authenticationMethod);
        Property username = properties.get("username");
        if (MailServer.AuthenticationMethod.OAUTH2.toString().equals(authenticationMethod.getString())) {
            ComponentState auth = this.createComponentPair("authenticationMethod", "oauth2ClientRegistration", object, properties, context);
            this.addComponent(auth);
            list.add(username);
            MutablePropertySet set = new MutablePropertySet((PropertySet)new PropertySetImpl(list));
            set.setReadOnly("username");
            children = set;
        } else {
            list.add(username);
            list.add(properties.get("password"));
            children = new PropertySetImpl(list);
        }
        ComponentGrid grid = this.createGrid(object, new ArrayList(children.getProperties()), context);
        return grid.createGrid();
    }
}

