/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.mapping;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Target;
import org.openvpms.web.component.im.edit.AbstractSelectorPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.property.AbstractEditor;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.mapping.AbstractMappingTableModel;
import org.openvpms.web.workspace.admin.mapping.MappingBrowser;
import org.openvpms.web.workspace.admin.mapping.TargetResultSet;

public class TargetEditor
extends AbstractEditor {
    private final Mappings<?> mappings;
    private final AbstractSelectorPropertyEditor<Target> editor;

    public TargetEditor(Target target, Mappings<?> mappings, LayoutContext context) {
        this.mappings = mappings;
        this.editor = new TargetPropertyEditor(target, mappings.getTargetDisplayName(), context);
        this.editor.addModifiableListener(modifiable -> this.notifyListeners());
    }

    public Target getObject() {
        return (Target)this.editor.getObject();
    }

    public Component getComponent() {
        return this.editor.getComponent();
    }

    protected boolean doValidation(Validator validator) {
        return this.editor.validate(validator);
    }

    private static class TargetTableModel
    extends AbstractMappingTableModel<Target> {
        private TargetTableModel() {
        }

        protected Object getValue(Target object, TableColumn column, int row) {
            if (column.getModelIndex() == 0) {
                return object.getId();
            }
            return object.getName();
        }
    }

    private class TargetPropertyEditor
    extends AbstractSelectorPropertyEditor<Target> {
        TargetPropertyEditor(Target target, String displayName, LayoutContext context) {
            super((Property)new SimpleProperty("target", (Object)target, Target.class, displayName), context);
            this.updateSelector();
        }

        public Target getObject() {
            return (Target)this.getProperty().getValue();
        }

        protected boolean doValidation(Validator validator) {
            boolean result = false;
            AbstractQuerySelector selector = this.getSelector();
            if (!selector.inSelect()) {
                if (!selector.isValid()) {
                    String message = Messages.format((String)"mapping.targetnotfound", (Object[])new Object[]{selector.getText(), TargetEditor.this.editor.getProperty().getDisplayName()});
                    validator.add((Modifiable)this, new ValidatorError(message));
                } else {
                    result = super.doValidation(validator);
                }
            }
            return result;
        }

        protected AbstractQuerySelector<Target> createSelector(Property property, LayoutContext context, boolean allowCreate) {
            return new TargetSelector(property, allowCreate, context);
        }

        protected boolean updateProperty(Property property, Target value) {
            return property.setValue((Object)value);
        }

        private class TargetSelector
        extends AbstractQuerySelector<Target> {
            TargetSelector(Property property, boolean allowCreate, LayoutContext context) {
                super(property.getDisplayName(), allowCreate, context);
            }

            protected String getName(Target object) {
                return object.getName();
            }

            protected String getDescription(Target object) {
                return null;
            }

            protected boolean getActive(Target object) {
                return object.isActive();
            }

            protected Browser<Target> createBrowser(String value, boolean runQuery) {
                return new TargetBrowser(value, TargetPropertyEditor.this.getLayoutContext());
            }

            protected BrowserDialog<Target> createDialog(Browser<Target> browser) {
                BrowserDialog dialog = super.createDialog(browser);
                dialog.resize("BrowserDialog.size.Mapping.Target");
                return dialog;
            }

            protected ResultSet<Target> getMatches(String value) {
                return new TargetResultSet(value, 20, TargetEditor.this.mappings);
            }

            protected void onTextChanged() {
                super.onTextChanged();
                TargetEditor.this.setModified();
                TargetEditor.this.notifyListeners();
            }
        }
    }

    private class TargetBrowser
    extends MappingBrowser<Target> {
        TargetBrowser(String value, LayoutContext context) {
            super(value, new TargetTableModel(), context);
        }

        @Override
        protected ResultSet<Target> createResultSet(String value, int maxResults) {
            return new TargetResultSet(value, maxResults, TargetEditor.this.mappings);
        }
    }
}

