/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.mapping;

import nextapp.echo2.app.table.TableColumn;
import org.openvpms.component.model.object.Reference;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Source;
import org.openvpms.web.component.im.edit.AbstractSelectorPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.workspace.admin.mapping.AbstractMappingTableModel;
import org.openvpms.web.workspace.admin.mapping.MappingBrowser;
import org.openvpms.web.workspace.admin.mapping.MappingSource;
import org.openvpms.web.workspace.admin.mapping.SourceImpl;
import org.openvpms.web.workspace.admin.mapping.SourceResultSet;

class SourceEditor
extends AbstractSelectorPropertyEditor<Source>
implements MappingSource {
    private final Mappings<?> mappings;

    SourceEditor(Reference source, Mappings<?> mappings, LayoutContext context) {
        super((Property)new SimpleProperty("source", Reference.class), context);
        this.getProperty().setValue((Object)source);
        this.mappings = mappings;
        this.updateSelector();
    }

    @Override
    public Source getObject() {
        Reference ref = this.getProperty().getReference();
        return ref != null ? new SourceImpl(ref, IMObjectHelper.getName((Reference)ref)) : null;
    }

    protected AbstractQuerySelector<Source> createSelector(Property property, LayoutContext context, boolean allowCreate) {
        return new AbstractQuerySelector<Source>(property.getDisplayName(), allowCreate, context){

            protected String getName(Source object) {
                return object.getName();
            }

            protected String getDescription(Source object) {
                return null;
            }

            protected boolean getActive(Source object) {
                return true;
            }

            protected Browser<Source> createBrowser(String value, boolean runQuery) {
                return new SourceBrowser(value, SourceEditor.this.getLayoutContext());
            }

            protected ResultSet<Source> getMatches(String value) {
                return new SourceResultSet(value, 20, SourceEditor.this.mappings);
            }
        };
    }

    protected boolean updateProperty(Property property, Source value) {
        Reference reference = value != null ? value.getId() : null;
        return property.setValue((Object)reference);
    }

    private static class SourceTableModel
    extends AbstractMappingTableModel<Source> {
        private SourceTableModel() {
        }

        protected Object getValue(Source object, TableColumn column, int row) {
            if (column.getModelIndex() == 0) {
                return object.getId().getId();
            }
            return object.getName();
        }
    }

    private class SourceBrowser
    extends MappingBrowser<Source> {
        SourceBrowser(String value, LayoutContext context) {
            super(value, new SourceTableModel(), context);
        }

        @Override
        protected ResultSet<Source> createResultSet(String value, int maxResults) {
            return new SourceResultSet(value, maxResults, SourceEditor.this.mappings);
        }
    }
}

