/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openvpms.component.model.object.Reference;
import org.openvpms.mapping.model.Mapping;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Source;
import org.openvpms.mapping.model.Target;
import org.openvpms.web.workspace.admin.mapping.AbstractMappingResultSet;
import org.openvpms.web.workspace.admin.mapping.MappingState;

public class MappingResultSet
extends AbstractMappingResultSet<Mapping> {
    private final Mappings<?> mappings;
    private List<Target> unmappedTargets;

    MappingResultSet(String value, int pageSize, Mappings<?> mappings) {
        super(value, pageSize);
        this.mappings = mappings;
    }

    @Override
    protected List<Mapping> getMatches(String value, int firstResult, int maxResults) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        int size = 0;
        List unmapped = Collections.emptyList();
        if (firstResult < size) {
            for (int i = firstResult; i < size; ++i) {
                result.add(new MappingState(null, (Target)unmapped.get(i), null));
            }
            if (firstResult + maxResults > size) {
                int remainder = maxResults - size;
                this.getSources(value, 0, remainder, result);
            }
        } else {
            this.getSources(value, firstResult -= size, maxResults, result);
        }
        return result;
    }

    @Override
    protected int countResults(String value) {
        int count = (int)this.mappings.getSourceCount(value, false);
        return count;
    }

    private void getSources(String value, int firstResult, int maxResults, List<Mapping> results) {
        for (Source source : this.mappings.getSources(value, false, firstResult, maxResults)) {
            Reference id = source.getId();
            Mapping mapping = this.mappings.getMapping(id);
            Target target = mapping != null ? mapping.getTarget() : null;
            results.add(new MappingState(id, target, mapping));
        }
    }

    private List<Target> getUnmapped(String value) {
        if (this.unmappedTargets == null) {
            this.unmappedTargets = this.mappings.getTargets(value, true, 0, -1);
        }
        return this.unmappedTargets;
    }
}

