/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.mapping;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractTableBrowser;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.workspace.admin.mapping.AbstractMappingTableModel;

abstract class MappingBrowser<T>
extends AbstractTableBrowser<T> {
    private String value;
    private TextComponent search;
    static final int MAX_RESULTS = 20;

    MappingBrowser(String value, AbstractMappingTableModel<T> model, LayoutContext context) {
        super(model, context);
        this.value = value;
    }

    public void query() {
        Component component = this.getComponent();
        this.value = StringUtils.trimToNull((String)this.search.getText());
        ResultSet<T> set = this.createResultSet(this.value, 20);
        boolean hasResults = this.hasResults(set);
        this.doLayout(component, hasResults);
        PagedIMTable table = this.getTable();
        table.setResultSet(set);
        this.setFocusOnResults();
    }

    protected abstract ResultSet<T> createResultSet(String var1, int var2);

    protected void doLayout() {
        super.doLayout();
        this.query();
    }

    protected void doLayout(Component container) {
        this.search = TextComponentFactory.create();
        this.search.setText(this.value);
        this.search.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                MappingBrowser.this.query();
            }
        });
        FocusGroup group = this.getFocusGroup();
        ButtonRow row = new ButtonRow(group);
        row.add((Component)this.search);
        row.addButton("button.query", (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                MappingBrowser.this.query();
            }
        });
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{row}));
    }
}

