/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.servlet.ServletHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.security.oauth.ClientRegistrationRepositoryImpl;
import org.openvpms.web.system.ServiceHelper;

public class OAuth2ClientRegistrationLayoutStrategy
extends AbstractLayoutStrategy {
    private final ClientRegistrationRepositoryImpl repository = (ClientRegistrationRepositoryImpl)ServiceHelper.getBean(ClientRegistrationRepositoryImpl.class);
    private Label redirectURI;
    private static final String TENANT_ID = "tenantId";

    public OAuth2ClientRegistrationLayoutStrategy() {
        super(new ArchetypeNodes());
    }

    public void updateRedirectURI(Lookup object) {
        this.redirectURI.setText(this.getRedirectURI(object));
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Lookup lookup = (Lookup)object;
        if (!"outlook".equals(lookup.getCode())) {
            this.getArchetypeNodes().exclude(new String[]{TENANT_ID});
        }
        return super.apply(object, properties, parent, context);
    }

    protected ComponentGrid createGrid(IMObject object, List<Property> properties, LayoutContext context) {
        ComponentGrid grid = super.createGrid(object, properties, context);
        if (this.redirectURI == null) {
            this.redirectURI = LabelFactory.create();
        }
        this.updateRedirectURI((Lookup)object);
        grid.add(new ComponentState[]{new ComponentState((Component)this.redirectURI, null, null, Messages.get((String)"admin.lookup.oauth2.redirectUri"))});
        return grid;
    }

    private String getRedirectURI(Lookup object) {
        String result = null;
        if (object.getCode() != null) {
            result = this.repository.getRedirectURI(object.getCode(), ServletHelper.getRequest());
        }
        return result;
    }
}

