/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.laboratory.io;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.laboratory.internal.io.LaboratoryTestProductData;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.PricingContextFactory;
import org.openvpms.web.component.im.product.ProductPricingContext;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.DefaultListMarkModel;
import org.openvpms.web.component.im.table.ListMarkModel;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;

class LaboratoryTestProductDataModel
extends AbstractIMTableModel<LaboratoryTestProductData> {
    private final ProductPricingContext pricingContext;
    private Date now;
    private static final int ID = 1;
    private static final int NAME = 2;
    private static final int TESTS = 3;
    private static final int NEW_COST = 4;
    private static final int NEW_PRICE = 5;
    private static final int OLD_COST = 6;
    private static final int OLD_PRICE = 7;

    public LaboratoryTestProductDataModel(LayoutContext context) {
        this.setRowMarkModel((ListMarkModel)new DefaultListMarkModel());
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        this.addMarkColumn((TableColumnModel)model);
        model.addColumn(LaboratoryTestProductDataModel.createTableColumn((int)1, (String)"table.imobject.id"));
        model.addColumn(LaboratoryTestProductDataModel.createTableColumn((int)2, (String)"table.imobject.name"));
        model.addColumn(LaboratoryTestProductDataModel.createTableColumn((int)3, (String)"admin.laboratory.import.tests"));
        model.addColumn(LaboratoryTestProductDataModel.createTableColumn((int)4, (String)"admin.laboratory.import.newCost"));
        model.addColumn(LaboratoryTestProductDataModel.createTableColumn((int)5, (String)"admin.laboratory.import.newPrice"));
        model.addColumn(LaboratoryTestProductDataModel.createTableColumn((int)6, (String)"admin.laboratory.import.oldCost"));
        model.addColumn(LaboratoryTestProductDataModel.createTableColumn((int)7, (String)"admin.laboratory.import.oldPrice"));
        this.setTableColumnModel((TableColumnModel)model);
        Party practice = context.getContext().getPractice();
        PricingContextFactory factory = (PricingContextFactory)ServiceHelper.getBean(PricingContextFactory.class);
        this.pricingContext = factory.createProductPricingContext(practice, context.getContext().getLocation());
    }

    public void preRender() {
        this.now = new Date();
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        return null;
    }

    protected Object getValue(LaboratoryTestProductData object, TableColumn column, int row) {
        Object result;
        switch (column.getModelIndex()) {
            case 0: {
                result = this.getRowMark(row);
                break;
            }
            case 1: {
                result = object.getNewProduct().getId();
                break;
            }
            case 2: {
                result = object.getNewProduct().getName();
                break;
            }
            case 3: {
                result = this.getTests(object.getTests());
                break;
            }
            case 4: {
                result = this.getCurrency(object.getNewCost());
                break;
            }
            case 5: {
                result = this.getCurrency(this.pricingContext.getTaxExPrice(object.getNewProduct(), this.now));
                break;
            }
            case 6: {
                result = this.getCurrency(object.getOldCost());
                break;
            }
            case 7: {
                result = this.getCurrency(this.pricingContext.getTaxExPrice(object.getOldProduct(), this.now));
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private Component getTests(List<Entity> tests) {
        String text = tests.stream().map(IMObject::getName).sorted().collect(Collectors.joining("\n"));
        return LabelFactory.text((String)text);
    }

    private Label getCurrency(BigDecimal value) {
        return TableHelper.rightAlign((String)NumberFormatter.formatCurrency((Number)value));
    }
}

