/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.scheduledreport;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.report.ParameterType;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;

public class Parameters {
    public static final String PARAM_NAME = "paramName";
    public static final String PARAM_DISPLAY_NAME = "paramDisplayName";
    public static final String PARAM_TYPE = "paramType";
    public static final String PARAM_EXPR_TYPE = "paramExprType";
    public static final String PARAM_VALUE = "paramValue";
    private final PropertySet properties;
    private int maxParameters;
    private int parameterCount;

    public Parameters(PropertySet properties) {
        Property property;
        this.properties = properties;
        int paramIndex = 0;
        this.parameterCount = 0;
        while ((property = this.getParamName(paramIndex)) != null) {
            ++paramIndex;
            if (StringUtils.isEmpty((CharSequence)property.getName())) continue;
            ++this.parameterCount;
        }
        this.maxParameters = paramIndex;
    }

    public Property getParamName(int index) {
        return this.properties.get(PARAM_NAME + index);
    }

    public Property getParamDisplayName(int index) {
        return this.properties.get(PARAM_DISPLAY_NAME + index);
    }

    public Property getParamType(int index) {
        return this.properties.get(PARAM_TYPE + index);
    }

    public Property getParamExpressionType(int index) {
        return this.properties.get(PARAM_EXPR_TYPE + index);
    }

    public Property getParamValue(int index) {
        return this.properties.get(PARAM_VALUE + index);
    }

    public void setParameter(int index, ParameterType type) {
        this.setParameter(index, type.getName(), type.getDescription(), type.getType().getName(), type.getDefaultValue());
    }

    public void setParameter(int index, String name, String displayName, String type, Object value) {
        Property paramName = this.getParamName(index);
        Property paramDisplayName = this.getParamDisplayName(index);
        Property paramType = this.getParamType(index);
        Property paramExpressionType = this.getParamExpressionType(index);
        Property paramValue = this.getParamValue(index);
        paramName.setValue((Object)name);
        paramType.setValue((Object)type);
        paramDisplayName.setValue((Object)displayName);
        paramExpressionType.setValue(null);
        paramValue.setValue(value);
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public int getMaxParameters() {
        return this.maxParameters;
    }

    public void update(Set<ParameterType> parameterTypes) {
        int i;
        ArrayList<ParameterType> list = new ArrayList<ParameterType>();
        for (ParameterType type : parameterTypes) {
            if (!this.isSupportedParameter(type)) continue;
            list.add(type);
        }
        this.parameterCount = list.size();
        for (i = 0; i < list.size() && i < this.maxParameters; ++i) {
            ParameterType type;
            type = (ParameterType)list.get(i);
            this.setParameter(i, type);
        }
        while (i < this.maxParameters) {
            this.setParameter(i, null, null, null, null);
            ++i;
        }
    }

    private boolean isSupportedParameter(ParameterType parameterType) {
        if (!parameterType.isSystem()) {
            SimpleProperty dummy = new SimpleProperty("dummy", parameterType.getType());
            return dummy.isString() || dummy.isBoolean() || dummy.isNumeric() || dummy.isDate();
        }
        return false;
    }
}

