/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.scheduledreport;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.system.common.util.ClassHelper;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.workspace.admin.job.scheduledreport.DateParameter;
import org.openvpms.web.workspace.admin.job.scheduledreport.DateParameterViewer;
import org.openvpms.web.workspace.admin.job.scheduledreport.Parameters;

class ParameterComponents {
    private final Map<Property, Integer> parameters = new LinkedHashMap<Property, Integer>();
    private final Map<Property, ComponentState> components = new HashMap<Property, ComponentState>();
    private final Map<Property, Editor> editors = new LinkedHashMap<Property, Editor>();

    public ParameterComponents(Parameters parameters, LayoutContext context) {
        int i = 0;
        while (true) {
            Property paramName = parameters.getParamName(i);
            Property paramDisplayName = parameters.getParamDisplayName(i);
            Property paramType = parameters.getParamType(i);
            Property paramExpressionType = parameters.getParamExpressionType(i);
            Property paramValue = parameters.getParamValue(i);
            if (paramName == null || paramDisplayName == null || paramType == null || paramValue == null) break;
            String name = paramName.getString();
            String displayName = StringUtils.trimToNull((String)paramDisplayName.getString());
            String typeName = paramType.getString();
            Class<?> type = this.getClass(typeName);
            if (!StringUtils.isEmpty((CharSequence)name) && type != null) {
                ComponentState state;
                SimpleProperty property;
                boolean readOnly;
                DateParameter editor = null;
                boolean bl = readOnly = !context.isEdit();
                if (Date.class.isAssignableFrom(type)) {
                    if (readOnly) {
                        DateParameterViewer viewer = new DateParameterViewer(name, displayName, paramExpressionType, paramValue, context);
                        property = viewer.getProperty();
                        state = new ComponentState(viewer.getComponent(), (Property)property);
                    } else {
                        DateParameter parameter = new DateParameter(name, displayName, paramExpressionType, paramValue, context);
                        property = parameter.getProperty();
                        editor = parameter;
                        state = new ComponentState((PropertyEditor)editor);
                    }
                } else {
                    property = new SimpleProperty(name, paramValue.getValue(), type, displayName, readOnly);
                    Component component = context.getComponentFactory().create((Property)property);
                    if (!readOnly) {
                        property.addModifiableListener(arg_0 -> ParameterComponents.lambda$new$0(paramValue, (Property)property, arg_0));
                        editor = new PropertyComponentEditor((Property)property, component);
                    }
                    state = new ComponentState(component, (Property)property);
                }
                this.components.put((Property)property, state);
                if (context.isEdit()) {
                    this.editors.put((Property)property, (Editor)editor);
                }
                this.parameters.put((Property)property, i);
            }
            ++i;
        }
    }

    public Collection<Property> getParameters() {
        return this.parameters.keySet();
    }

    public ComponentState getComponent(Property parameter) {
        return this.components.get(parameter);
    }

    public Collection<Editor> getEditors() {
        return this.editors.values();
    }

    public void exclude(Property parameter, ArchetypeNodes nodes) {
        Integer id = this.parameters.get(parameter);
        if (id != null) {
            nodes.exclude(new String[]{"paramName" + id});
            nodes.exclude(new String[]{"paramDisplayName" + id});
            nodes.exclude(new String[]{"paramType" + id});
            nodes.exclude(new String[]{"paramExprType" + id});
            nodes.exclude(new String[]{"paramValue" + id});
        }
    }

    private Class<?> getClass(String className) {
        Class type = null;
        if (!StringUtils.isEmpty((CharSequence)className)) {
            try {
                type = ClassHelper.getClass((String)className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return type;
    }

    private static /* synthetic */ void lambda$new$0(Property paramValue, Property property, Modifiable modifiable) {
        paramValue.setValue(property.getValue());
    }
}

