/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.scheduledreport;

import java.util.Date;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.job.scheduledreport.DateOffset;
import org.openvpms.web.workspace.admin.job.scheduledreport.ExpressionType;

class DateParameterViewer {
    private final Component component;
    private final SimpleProperty property;

    public DateParameterViewer(String name, String displayName, Property expressionType, Property value, LayoutContext context) {
        IMObjectComponentFactory factory = context.getComponentFactory();
        if (ExpressionType.VALUE.toString().equals(expressionType.getString())) {
            this.property = new SimpleProperty(name, (Object)value.getDate(), Date.class, displayName, true);
        } else {
            StringBuilder builder = new StringBuilder();
            String expr = Messages.get((String)("scheduledreport.expression." + expressionType.getString()));
            builder.append(expr);
            String currentValue = StringUtils.trimToNull((String)value.getString());
            DateOffset offset = DateOffset.parse(currentValue);
            if (offset != null) {
                builder.append(' ');
                if (offset.getOffset() > 0) {
                    builder.append("+ ");
                }
                builder.append(offset.getOffset());
                builder.append(' ');
                builder.append(Messages.get((String)("scheduledreport.dateunits." + offset.getUnits())));
            }
            this.property = new SimpleProperty(name, (Object)builder.toString(), String.class, displayName, true);
        }
        this.component = factory.create((Property)this.property);
    }

    public Property getProperty() {
        return this.property;
    }

    public Component getComponent() {
        return this.component;
    }
}

