/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.scheduledreport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openvpms.archetype.rules.util.DateUnits;

class DateOffset {
    private final int offset;
    private final DateUnits units;

    public DateOffset(int offset, DateUnits units) {
        this.offset = offset;
        this.units = units;
    }

    public int getOffset() {
        return this.offset;
    }

    public DateUnits getUnits() {
        return this.units;
    }

    public static DateOffset parse(String value) {
        DateOffset result = null;
        int offset = 0;
        DateUnits units = null;
        if (value != null) {
            Pattern pattern = Pattern.compile("([+-]?\\d+)([dmwy])");
            Matcher matcher = pattern.matcher(value);
            if (matcher.matches()) {
                String valueGroup = matcher.group(1);
                offset = Integer.parseInt(valueGroup);
                String type = matcher.group(2);
                if ("d".equals(type)) {
                    units = DateUnits.DAYS;
                } else if ("w".equals(type)) {
                    units = DateUnits.WEEKS;
                } else if ("m".equals(type)) {
                    units = DateUnits.MONTHS;
                } else if ("y".equals(type)) {
                    units = DateUnits.YEARS;
                }
            }
            if (units != null) {
                result = new DateOffset(offset, units);
            }
        }
        return result;
    }
}

