/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.account;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.PeriodHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.edit.Deletable;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.EntityLinkCollectionTargetPropertyEditor;
import org.openvpms.web.component.im.relationship.MultipleRelationshipCollectionTargetEditor;
import org.openvpms.web.component.im.relationship.RelationshipCollectionTargetPropertyEditor;
import org.openvpms.web.component.im.relationship.SequencedCollectionResultSetFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.system.ServiceHelper;

class AccountReminderCollectionEditor
extends MultipleRelationshipCollectionTargetEditor
implements Deletable {
    public AccountReminderCollectionEditor(CollectionProperty property, Entity object, LayoutContext context) {
        super((RelationshipCollectionTargetPropertyEditor)new AccountReminderPropertyEditor(property, object, (IMObjects)context.getCache()), (IMObject)object, context, SequencedCollectionResultSetFactory.INSTANCE);
    }

    public boolean add(IMObject object) {
        boolean result = super.add(object);
        this.resequence();
        return result;
    }

    public void remove(IMObject object) {
        super.remove(object);
        this.resequence();
    }

    public void delete() {
        IMObjectBean bean = this.getBean(this.getObject());
        boolean changed = false;
        Collection counts = this.getCurrentObjects();
        for (IMObject count : counts) {
            Relationship relationship = bean.removeTarget("reminders", count);
            if (relationship == null) continue;
            changed = true;
        }
        if (changed) {
            ServiceHelper.getArchetypeService().save(this.getObject(), false);
            for (IMObject count : counts) {
                IMObjectEditor editor = this.getEditor(count);
                if (editor == null) continue;
                editor.delete();
            }
        }
    }

    protected static Period getInterval(IMObject object) {
        return PeriodHelper.getPeriod((IMObjectBean)ServiceHelper.getArchetypeService().getBean(object), (String)"interval", (String)"units", (Period)Period.days((int)0));
    }

    private void resequence() {
        AccountReminderPropertyEditor editor = (AccountReminderPropertyEditor)this.getCollectionPropertyEditor();
        editor.sequence();
    }

    private static class AccountReminderPropertyEditor
    extends EntityLinkCollectionTargetPropertyEditor {
        public AccountReminderPropertyEditor(CollectionProperty property, Entity parent, IMObjects objects) {
            super(property, parent, objects);
        }

        protected void sequence() {
            Map map = this.getTargets();
            ArrayList entries = new ArrayList(map.entrySet());
            Date now = new Date();
            entries.sort((o1, o2) -> {
                Period period1 = AccountReminderCollectionEditor.getInterval((IMObject)o1.getKey());
                Period period2 = AccountReminderCollectionEditor.getInterval((IMObject)o2.getKey());
                return DateRules.plus((Date)now, (Period)period1).compareTo(DateRules.plus((Date)now, (Period)period2));
            });
            int sequence = 0;
            for (Map.Entry entry : entries) {
                EntityLink link = (EntityLink)entry.getValue();
                link.setSequence(sequence++);
            }
        }
    }
}

