/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.list.ShortNameListModel;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class LookupMappingExportDialog
extends ModalDialog {
    private final SelectField mapFrom;
    private final SelectField mapTo;

    public LookupMappingExportDialog(HelpContext help) {
        super(Messages.get((String)"admin.hl7.mapping.export.title"), "MessageDialog", OK_CANCEL, help);
        List<String> shortNames = Collections.singletonList("lookup.species");
        this.mapFrom = SelectFieldFactory.create((ListModel)new ShortNameListModel(shortNames, false, true));
        this.mapFrom.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                LookupMappingExportDialog.this.onFromChanged();
            }
        });
        this.mapTo = SelectFieldFactory.create((ListModel)this.createModel(this.getMapFrom()));
        this.mapTo.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                LookupMappingExportDialog.this.onToChanged();
            }
        });
        this.onChanged();
    }

    public String getMapFrom() {
        return (String)this.mapFrom.getSelectedItem();
    }

    public String getMapTo() {
        return (String)this.mapTo.getSelectedItem();
    }

    protected void onOK() {
        String from = this.getMapFrom();
        String to = this.getMapTo();
        if (from != null && to != null && !Objects.equals(from, to)) {
            super.onOK();
        }
    }

    protected void doLayout() {
        Label message = LabelFactory.create((String)"admin.hl7.mapping.export.message", (String)"bold");
        Row from = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"admin.hl7.mapping.export.from"), this.mapFrom});
        Row to = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"admin.hl7.mapping.export.to"), this.mapTo});
        Row inset = RowFactory.create((String)"Inset.Large", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{from, to})})});
        this.getLayout().add((Component)inset);
    }

    private void onFromChanged() {
        String from = this.getMapFrom();
        this.mapTo.setModel((ListModel)this.createModel(from));
        this.onChanged();
    }

    private ShortNameListModel createModel(String from) {
        ShortNameListModel model;
        if (from != null) {
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            String[] mappings = DescriptorHelper.getNodeShortNames((String)from, (String)"mapping", (ArchetypeService)service);
            HashSet<String> archetypes = new HashSet<String>();
            for (String shortName : mappings) {
                String[] target = DescriptorHelper.getNodeShortNames((String)shortName, (String)"target", (ArchetypeService)service);
                archetypes.addAll(Arrays.asList(target));
            }
            model = new ShortNameListModel(new ArrayList(archetypes), false, true);
        } else {
            model = new ShortNameListModel(new ArrayList(), false, true);
        }
        return model;
    }

    private void onToChanged() {
        this.onChanged();
    }

    private void onChanged() {
        String from = this.getMapFrom();
        String to = this.getMapTo();
        boolean enabled = from != null && to != null && !Objects.equals(from, to);
        this.getButtons().setEnabled("ok", enabled);
    }
}

