/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.csv.AbstractCSVReader;
import org.openvpms.archetype.csv.CSVReaderException;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.document.Document;
import org.openvpms.web.workspace.admin.hl7.LookupMapping;
import org.openvpms.web.workspace.admin.hl7.LookupMappingCSVWriter;
import org.openvpms.web.workspace.admin.hl7.LookupMappings;

public class LookupMappingCSVReader
extends AbstractCSVReader {
    private static final int FROM_TYPE = 0;
    private static final int FROM_CODE = 1;
    private static final int FROM_NAME = 2;
    private static final int TO_TYPE = 3;
    private static final int TO_CODE = 4;
    private static final int TO_NAME = 5;

    public LookupMappingCSVReader(DocumentHandlers handlers, char separator) {
        super(handlers, LookupMappingCSVWriter.HEADER, separator);
    }

    public LookupMappings read(Document document) {
        ArrayList<LookupMapping> mappings = new ArrayList<LookupMapping>();
        ArrayList<LookupMapping> errors = new ArrayList<LookupMapping>();
        List lines = this.readLines(document);
        int lineNo = 2;
        for (String[] line : lines) {
            this.parse(line, mappings, errors, lineNo);
            ++lineNo;
        }
        return new LookupMappings(mappings, errors);
    }

    private void parse(String[] line, List<LookupMapping> data, List<LookupMapping> errors, int lineNo) {
        String fromType = null;
        String fromCode = null;
        String fromName = null;
        String toType = null;
        String toCode = null;
        String toName = null;
        try {
            this.checkFields(line, lineNo);
            fromType = this.getString(line, 0, lineNo, true);
            fromCode = this.getString(line, 1, lineNo, true);
            fromName = this.getString(line, 2, lineNo, true);
            toType = this.getString(line, 3, lineNo, true);
            toCode = this.getString(line, 4, lineNo, true);
            toName = this.getString(line, 5, lineNo, true);
            data.add(new LookupMapping(fromType, fromCode, fromName, toType, toCode, toName, lineNo));
        }
        catch (CSVReaderException exception) {
            LookupMapping invalid = new LookupMapping(fromType, fromCode, fromName, toType, toCode, toName, lineNo);
            invalid.setError(exception.getMessage());
            errors.add(invalid);
        }
    }
}

