/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.AbstractIMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.admin.hl7.HL7MessageDialog;

public class HL7ConnectorCRUDWindow
extends AbstractViewCRUDWindow<Entity> {
    private static final String MESSAGES_ID = "button.messages";
    private static final String STOP_ID = "button.stop";
    private static final String START_ID = "button.start";

    public HL7ConnectorCRUDWindow(Archetypes<Entity> archetypes, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)new Actions(), context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(MESSAGES_ID, this::onMessages);
        buttons.add(STOP_ID, this::onStop);
        buttons.add(START_ID, this::onStart);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(MESSAGES_ID, enable);
        Entity connector = (Entity)this.getObject();
        Actions actions = this.getActions();
        buttons.setEnabled(STOP_ID, enable && actions.canStop(connector));
        buttons.setEnabled(START_ID, enable && actions.canStart(connector));
    }

    protected Actions getActions() {
        return (Actions)super.getActions();
    }

    private void onMessages() {
        Entity connector = (Entity)this.getObject();
        if (connector != null) {
            HelpContext help = this.getHelpContext().subtopic("message");
            HL7MessageDialog dialog = new HL7MessageDialog(connector, this.getContext(), help);
            dialog.show();
        }
    }

    private void onStop() {
        Entity connector = (Entity)IMObjectHelper.reload((IMObject)this.getObject());
        if (connector != null && this.getActions().canStop(connector)) {
            this.getActions().stop(connector);
            this.onRefresh((IMObject)connector);
        }
    }

    private void onStart() {
        Entity connector = (Entity)IMObjectHelper.reload((IMObject)this.getObject());
        if (connector != null && this.getActions().canStart(connector)) {
            this.getActions().start(connector);
            this.onRefresh((IMObject)connector);
        }
    }

    private static class Actions
    extends AbstractIMObjectActions<Entity> {
        private static final String SUSPENDED = "suspended";

        private Actions() {
        }

        public boolean canStop(Entity connector) {
            IMObjectBean bean = this.getBean((IMObject)connector);
            return bean.hasNode(SUSPENDED) && !bean.getBoolean(SUSPENDED);
        }

        public boolean canStart(Entity connector) {
            IMObjectBean bean = this.getBean((IMObject)connector);
            return bean.hasNode(SUSPENDED) && bean.getBoolean(SUSPENDED);
        }

        public void stop(Entity connector) {
            IMObjectBean bean = this.getBean((IMObject)connector);
            bean.setValue(SUSPENDED, (Object)true);
            bean.save();
        }

        public void start(Entity connector) {
            IMObjectBean bean = this.getBean((IMObject)connector);
            bean.setValue(SUSPENDED, (Object)false);
            bean.save();
        }
    }
}

