/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.layout.CellLayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.hl7.io.MessageDispatcher;
import org.openvpms.hl7.io.Statistics;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.IMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.BaseIMObjectTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;

public class HL7ConnectorBrowser
extends IMObjectTableBrowser<Entity> {
    public HL7ConnectorBrowser(Query<Entity> query, LayoutContext context) {
        super(query, context);
    }

    protected IMTableModel<Entity> createTableModel(LayoutContext context) {
        return new Model((Query<Entity>)this.getQuery());
    }

    private static class Model
    extends BaseIMObjectTableModel<Entity> {
        private int lastRow = -1;
        private Statistics stats = null;
        private final MessageDispatcher dispatcher;
        private static final int RUNNING = 6;
        private static final int QUEUED = 7;
        private static final int ERRORS = 8;
        private static final int LAST_PROCESSED = 9;
        private static final int LAST_ERROR = 10;
        private static final int LAST_ERROR_MSG = 11;

        public Model(Query<Entity> query) {
            super(null);
            boolean showArchetype = query.getShortNames().length > 1;
            boolean showActive = query.getActive() == BaseArchetypeConstraint.State.BOTH;
            DefaultTableColumnModel model = (DefaultTableColumnModel)this.createTableColumnModel(true, showArchetype, showActive);
            model.addColumn(Model.createTableColumn((int)6, (String)"admin.hl7.running"));
            model.addColumn(Model.createTableColumn((int)7, (String)"admin.hl7.queued"));
            model.addColumn(Model.createTableColumn((int)9, (String)"admin.hl7.lastprocessed"));
            model.addColumn(Model.createTableColumn((int)8, (String)"admin.hl7.errors"));
            model.addColumn(Model.createTableColumn((int)10, (String)"admin.hl7.lasterror"));
            model.addColumn(Model.createTableColumn((int)11, (String)"admin.hl7.lasterrormessage"));
            this.setTableColumnModel((TableColumnModel)model);
            this.dispatcher = (MessageDispatcher)ServiceHelper.getBean(MessageDispatcher.class);
        }

        public void postRender() {
            this.stats = null;
        }

        protected Object getValue(Entity object, TableColumn column, int row) {
            switch (column.getModelIndex()) {
                case 6: {
                    return this.getRunning(object, row);
                }
                case 7: {
                    return this.getQueued(object, row);
                }
                case 8: {
                    return this.getErrors(object, row);
                }
                case 9: {
                    return this.getLastProcessed(object, row);
                }
                case 10: {
                    return this.getLastError(object, row);
                }
                case 11: {
                    return this.getLastErrorMessage(object, row);
                }
            }
            return super.getValue((IMObject)object, column, row);
        }

        private Object getRunning(Entity object, int row) {
            Statistics stats = this.getStats(object, row);
            CheckBox box = CheckBoxFactory.create((stats != null && stats.isRunning() ? 1 : 0) != 0);
            box.setEnabled(false);
            return box;
        }

        private Component getQueued(Entity object, int row) {
            Statistics stats = this.getStats(object, row);
            int queued = stats != null ? stats.getQueued() : 0;
            return LabelFactory.create((long)queued, (CellLayoutData)new TableLayoutData());
        }

        private Component getErrors(Entity object, int row) {
            Statistics stats = this.getStats(object, row);
            int errors = stats != null ? stats.getErrors() : 0;
            return LabelFactory.create((long)errors, (CellLayoutData)new TableLayoutData());
        }

        private String getLastProcessed(Entity object, int row) {
            Date date;
            String result = null;
            Statistics stats = this.getStats(object, row);
            if (stats != null && (date = stats.getProcessedTimestamp()) != null) {
                result = DateFormatter.formatDateTimeAbbrev((Date)date);
            }
            return result;
        }

        private String getLastError(Entity object, int row) {
            Date date;
            String result = null;
            Statistics stats = this.getStats(object, row);
            if (stats != null && (date = stats.getErrorTimestamp()) != null) {
                result = DateFormatter.formatDateTimeAbbrev((Date)date);
            }
            return result;
        }

        private String getLastErrorMessage(Entity object, int row) {
            Statistics stats = this.getStats(object, row);
            return stats != null ? stats.getErrorMessage() : null;
        }

        private Statistics getStats(Entity object, int row) {
            if (row == this.lastRow) {
                return this.stats;
            }
            this.stats = this.dispatcher.getStatistics(object.getObjectReference());
            this.lastRow = row;
            return this.stats;
        }
    }
}

