/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.esci;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.layout.GridLayoutData;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.esci.adapter.dispatcher.ESCIDispatcher;
import org.openvpms.esci.adapter.dispatcher.Inbox;
import org.openvpms.esci.adapter.dispatcher.ProcessingConfig;
import org.openvpms.esci.adapter.map.invoice.LenientOrderResolver;
import org.openvpms.esci.adapter.map.invoice.OrderResolver;
import org.openvpms.esci.adapter.util.ESCIAdapterException;
import org.openvpms.esci.ubl.common.Document;
import org.openvpms.esci.ubl.io.UBLDocumentContext;
import org.openvpms.esci.ubl.io.UBLDocumentWriter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractBrowserListener;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.esci.DocumentReference;
import org.openvpms.web.workspace.admin.esci.ESCIDocumentBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ESCIDocumentDialog
extends ModalDialog {
    private final Inbox inbox;
    private final ESCIDocumentBrowser browser;
    private final ESCIDispatcher dispatcher;
    private final TextArea text;
    private static final String REFRESH_ID = "button.escirefresh";
    private static final String PROCESS_ID = "button.esciprocess";
    private static final String DELETE_ID = "button.delete";
    private static final Logger log = LoggerFactory.getLogger(ESCIDocumentDialog.class);

    public ESCIDocumentDialog(Inbox inbox, Context context, HelpContext help) {
        super("Inbox", "BrowserDialog", new String[0], help);
        this.inbox = inbox;
        this.dispatcher = (ESCIDispatcher)ServiceHelper.getBean(ESCIDispatcher.class);
        this.browser = new ESCIDocumentBrowser(inbox, (LayoutContext)new DefaultLayoutContext(context, help));
        this.browser.addBrowserListener((BrowserListener)new AbstractBrowserListener<DocumentReference>(){

            public void selected(DocumentReference object) {
                ESCIDocumentDialog.this.show(object);
            }
        });
        this.text = TextComponentFactory.createTextArea();
        this.text.setEnabled(false);
        this.addButton(REFRESH_ID, this::onRefresh);
        this.addButton(PROCESS_ID, this::onProcess);
        this.addButton(DELETE_ID, this::onDelete);
        this.addButton("close");
        this.enableButtons();
    }

    public void show() {
        super.show();
        this.refresh(null);
    }

    protected void doLayout() {
        this.text.setWidth(Styles.FULL_WIDTH);
        this.text.setHeight(Styles.FULL_HEIGHT);
        Grid grid = GridFactory.create((int)1, (Component[])new Component[]{this.text});
        grid.setInsets(StyleSheetHelper.getInsets(Column.class, (String)"Inset", (String)"insets"));
        GridLayoutData data = new GridLayoutData();
        grid.setRowHeight(0, Styles.FULL_HEIGHT);
        grid.setWidth(Styles.FULL_WIDTH);
        grid.setHeight(Styles.FULL_HEIGHT);
        this.text.setLayoutData((LayoutData)data);
        SplitPane pane = SplitPaneFactory.create((int)5, (String)"BrowserCRUDWorkspace.Layout", (Component[])new Component[]{this.browser.getComponent(), grid});
        this.getLayout().add((Component)pane);
    }

    private void enableButtons() {
        ButtonSet buttons = this.getButtons();
        boolean enable = this.browser.getSelected() != null;
        buttons.setEnabled(DELETE_ID, enable);
        buttons.setEnabled(PROCESS_ID, enable);
    }

    private void onRefresh() {
        this.refresh((DocumentReference)this.browser.getSelected());
    }

    private void onProcess() {
        DocumentReference selected = (DocumentReference)this.browser.getSelected();
        if (selected != null) {
            if (!this.browser.isFirstDocumentSelected()) {
                ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.format((String)"admin.esci.process.title", (Object[])new Object[]{selected.getDocumentType()}))).message(Messages.format((String)"admin.esci.process.outoforder", (Object[])new Object[]{selected.getDocumentType()}))).yesNo()).yes(() -> this.process(selected))).show();
            } else {
                this.process(selected);
            }
        } else {
            this.refresh(selected);
        }
    }

    private void process(DocumentReference document) {
        try {
            this.dispatcher.process(this.inbox, document.getReference(), null);
        }
        catch (ESCIAdapterException exception) {
            if ("Invoice".equals(document.getDocumentType())) {
                ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"admin.esci.retryprocessing.title"))).preamble(Messages.format((String)"admin.esci.process.failed", (Object[])new Object[]{document.getDocumentType()}))).message(exception.getMessage())).footer(Messages.format((String)"admin.esci.retryprocessing.retry", (Object[])new Object[]{document.getDocumentType()}))).yesNo()).yes(() -> this.processIgnoringOrderErrors(document))).show();
            } else {
                this.showError(exception, document);
            }
        }
        catch (Throwable exception) {
            this.showError(exception, document);
        }
    }

    private void processIgnoringOrderErrors(DocumentReference document) {
        try {
            LenientOrderResolver resolver = new LenientOrderResolver((ArchetypeService)ServiceHelper.getArchetypeService());
            this.dispatcher.process(this.inbox, document.getReference(), new ProcessingConfig((OrderResolver)resolver));
            if (!resolver.getErrors().isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (ESCIAdapterException exception : resolver.getErrors()) {
                    if (builder.length() != 0) {
                        builder.append("\n");
                    }
                    builder.append(exception.getMessage());
                }
                ((InformationDialogBuilder)((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().title(Messages.format((String)"admin.esci.process.title", (Object[])new Object[]{document.getDocumentType()}))).preamble(Messages.get((String)"admin.esci.processedwitherrors"))).message(builder.toString())).show();
            }
        }
        catch (Throwable exception) {
            this.showError(exception, document);
        }
    }

    private void showError(Throwable exception, DocumentReference document) {
        log.error("Failed to process document: " + exception.getMessage(), exception);
        ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().title(Messages.get((String)"admin.esci.process.failed.title"))).preamble(Messages.format((String)"admin.esci.process.failed", (Object[])new Object[]{document.getDocumentType()}))).message(ErrorFormatter.format((Throwable)exception))).show();
    }

    private void onDelete() {
        DocumentReference selected = (DocumentReference)this.browser.getSelected();
        if (selected != null) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.format((String)"imobject.delete.title", (Object[])new Object[]{selected.getDocumentType()}))).message(Messages.format((String)"imobject.delete.message", (Object[])new Object[]{selected.getDocumentType()}))).yesNo()).yes(() -> this.delete(selected))).show();
        }
    }

    private void delete(DocumentReference reference) {
        try {
            this.dispatcher.delete(this.inbox, reference.getReference());
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.refresh(null);
    }

    private void show(DocumentReference reference) {
        try {
            Document document = this.inbox.getDocument(reference.getReference());
            UBLDocumentContext context = new UBLDocumentContext();
            UBLDocumentWriter writer = context.createWriter();
            writer.setFormat(true);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            writer.write(document.getAny(), (OutputStream)stream, false);
            String string = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            this.text.setText(string);
        }
        catch (Throwable exception) {
            this.text.setText(ErrorFormatter.format((Throwable)exception));
        }
        this.enableButtons();
    }

    private void refresh(DocumentReference reference) {
        DocumentReference selected;
        this.browser.query();
        if (reference != null) {
            this.browser.setSelected(reference);
        }
        if ((selected = (DocumentReference)this.browser.getSelected()) != null) {
            this.show(selected);
        } else {
            this.text.setText(null);
        }
        this.enableButtons();
    }
}

