/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.esci;

import java.time.OffsetDateTime;
import java.util.Objects;
import org.openvpms.esci.ubl.common.aggregate.DocumentReferenceType;
import org.openvpms.esci.ubl.common.basic.IssueDateType;

class DocumentReference {
    public static final String INVOICE = "Invoice";
    private final DocumentReferenceType reference;

    public DocumentReference(DocumentReferenceType reference) {
        this.reference = reference;
    }

    public String getId() {
        return this.reference.getID() != null ? this.reference.getID().getValue() : null;
    }

    public String getDocumentType() {
        return this.reference.getDocumentType() != null ? this.reference.getDocumentType().getValue() : null;
    }

    public OffsetDateTime getIssueDate() {
        IssueDateType issueDate = this.reference.getIssueDate();
        return issueDate != null && issueDate.getValue() != null ? issueDate.getValue().toGregorianCalendar().toZonedDateTime().toOffsetDateTime() : null;
    }

    public DocumentReferenceType getReference() {
        return this.reference;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DocumentReference) {
            DocumentReference other = (DocumentReference)obj;
            return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getDocumentType(), other.getDocumentType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getDocumentType());
    }
}

