/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.calendar;

import echopointng.LabelEx;
import echopointng.layout.TableLayoutDataEx;
import echopointng.table.TableCellRendererEx;
import echopointng.xhtml.XhtmlFragment;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.AbstractCellTableModel;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.TableColumnFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.admin.calendar.CalendarGrid;
import org.openvpms.web.workspace.admin.calendar.CalendarHeaderCellRenderer;
import org.openvpms.web.workspace.admin.calendar.CalendarTableCellRenderer;

public class CalendarTableModel
extends AbstractCellTableModel {
    public static final int TIME_COLUMN = 0;
    private final CalendarGrid grid;

    public CalendarTableModel(CalendarGrid grid) {
        this.grid = grid;
        this.setTableColumnModel(this.createColumnModel(grid));
    }

    public Object getValueAt(int column, int row) {
        TableColumn col = this.getColumn(column);
        if (col == null) {
            throw new IllegalArgumentException("Illegal column=" + column);
        }
        return this.getValueAt(col, row);
    }

    public Object getValueAt(TableColumn column, int row) {
        int index = column.getModelIndex();
        Date result = index == 0 ? this.grid.getStartTime(row) : this.grid.getEvent(index - 1, row);
        return result;
    }

    public int getColumnCount() {
        return this.grid.getDays();
    }

    public int getRowCount() {
        return this.grid.getSlots();
    }

    public Availability getAvailability(int column, int row) {
        Availability result = Availability.UNAVAILABLE;
        TableColumn col = this.getColumn(column);
        if (col.getModelIndex() != 0) {
            PropertySet event = this.grid.getEvent(col.getModelIndex() - 1, row);
            result = event != null ? Availability.BUSY : Availability.FREE;
        }
        return result;
    }

    public PropertySet getEvent(Cell cell) {
        return this.getEvent(cell.getColumn(), cell.getRow());
    }

    public PropertySet getEvent(int column, int row) {
        return this.grid.getEvent(column - 1, row);
    }

    public Date getStartDate() {
        return this.grid.getStartDate();
    }

    public int getColumns(PropertySet event, int column) {
        DateTime endTime = new DateTime((Object)event.getDate("act.endTime"));
        int last = Days.daysBetween((ReadableInstant)new DateTime((Object)this.getStartDate()), (ReadableInstant)endTime).getDays();
        return last - column;
    }

    public int getRows(PropertySet event, int column, int row) {
        int lastSlot;
        Date end;
        Date columnDate = this.grid.getDatetime(column - 1, row);
        if (DateRules.dateEquals((Date)columnDate, (Date)(end = event.getDate("act.endTime")))) {
            DateTime endTime = new DateTime((Object)end);
            int minutes = endTime.getMinuteOfDay();
            int slotSize = this.grid.getSlotSize();
            lastSlot = minutes / slotSize;
            if (minutes % slotSize != 0 && lastSlot < this.grid.getSlots()) {
                ++lastSlot;
            }
        } else {
            lastSlot = this.grid.getSlots();
        }
        return lastSlot - row;
    }

    public int getFreeRows(int column, int row) {
        int rowSpan = 1;
        int rows = this.grid.getSlots();
        int currentHour = this.grid.getHour(row);
        for (int i = row + 1; i < rows && this.grid.getHour(i) == currentHour && this.getEvent(column, i) == null; ++i) {
            ++rowSpan;
        }
        return rowSpan;
    }

    public Date getDatetime(Cell cell) {
        int slot = cell.getColumn() - 1;
        return this.grid.getDatetime(slot, cell.getRow());
    }

    protected TableColumnModel createColumnModel(CalendarGrid grid) {
        DefaultTableColumnModel result = new DefaultTableColumnModel();
        int index = 0;
        TableColumn leftStartCol = this.createTimeColumn(index);
        result.addColumn(leftStartCol);
        CalendarTableCellRenderer renderer = new CalendarTableCellRenderer(this);
        Date startDate = grid.getStartDate();
        for (int i = 0; i < grid.getDays(); ++i) {
            TableColumn dateColumn = this.createDateColumn(++index, DateRules.getDate((Date)startDate, (int)i, (DateUnits)DateUnits.DAYS));
            dateColumn.setCellRenderer((TableCellRenderer)renderer);
            result.addColumn(dateColumn);
        }
        return result;
    }

    private TableColumn createTimeColumn(int modelIndex) {
        return TableColumnFactory.create((int)modelIndex, (TableCellRenderer)CalendarHeaderCellRenderer.INSTANCE, (TableCellRenderer)new TimeColumnCellRenderer());
    }

    private TableColumn createDateColumn(int modelIndex, Date date) {
        return TableColumnFactory.create((int)modelIndex, (Object)date, (TableCellRenderer)CalendarHeaderCellRenderer.INSTANCE, null);
    }

    private class TimeColumnCellRenderer
    implements TableCellRendererEx {
        private TimeColumnCellRenderer() {
        }

        public XhtmlFragment getTableCellRendererContent(Table table, Object value, int column, int row) {
            return null;
        }

        public boolean isSelectionCausingCell(Table table, int column, int row) {
            return false;
        }

        public boolean isActionCausingCell(Table table, int column, int row) {
            return false;
        }

        public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
            Label label;
            Date date = (Date)value;
            OffsetDateTime time = OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            int minute = time.getMinute();
            if (minute == 0) {
                label = LabelFactory.create((boolean)true);
                label.setText(DateFormatter.formatTime((Date)date, (boolean)false));
                ((LabelEx)label).setHeight(new Extent(50));
            } else {
                label = TableHelper.createSpacer();
            }
            TableLayoutDataEx data = new TableLayoutDataEx();
            data.setAlignment(new Alignment(5, 6));
            data.setRowSpan(4);
            label.setLayoutData((LayoutData)data);
            return label;
        }
    }

    public static enum Availability {
        FREE,
        BUSY,
        UNAVAILABLE;

    }
}

