/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.archetype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.filetransfer.UploadEvent;
import nextapp.echo2.app.filetransfer.UploadListener;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptorWriter;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptors;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptors;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.descriptor.cache.ArchetypeDescriptorCacheDB;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.tools.archetype.comparator.ArchetypeChange;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.doc.AbstractUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.edit.EditResultSetDialog;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.archetype.ArchetypeEditDialog;
import org.openvpms.web.workspace.admin.archetype.BatchArchetypeLoader;
import org.openvpms.web.workspace.admin.archetype.BatchArchetypeUpdater;
import org.openvpms.web.workspace.admin.archetype.ConfirmingBatchArchetypeUpdater;

public class ArchetypeCRUDWindow
extends ResultSetCRUDWindow<ArchetypeDescriptor> {
    private static final String IMPORT_ID = "button.import";
    private static final String EXPORT_ID = "button.export";
    private static final String RELOAD_ID = "button.reload";
    private static final String MIME_TYPE = "text/xml";

    public ArchetypeCRUDWindow(Archetypes<ArchetypeDescriptor> archetypes, Query<ArchetypeDescriptor> query, ResultSet<ArchetypeDescriptor> set, Context context, HelpContext help) {
        super(archetypes, query, set, context, help);
    }

    protected EditResultSetDialog<ArchetypeDescriptor> createEditResultSetDialog(ArchetypeDescriptor object, String title) {
        return new ArchetypeEditDialog(title, object, (ResultSet<ArchetypeDescriptor>)this.getResultSet(), (IMObjectActions<ArchetypeDescriptor>)this.getActions(), this.getContext(), this.getHelpContext());
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(IMPORT_ID, this::onImport);
        buttons.add(EXPORT_ID, this::onExport);
        buttons.add(RELOAD_ID, this::onReload);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(EXPORT_ID, enable);
    }

    private void onImport() {
        AbstractUploadListener listener = new AbstractUploadListener(){

            public void fileUpload(UploadEvent event) {
                InputStream stream = event.getInputStream();
                ArchetypeCRUDWindow.this.upload(stream, event.getFileName());
            }
        };
        UploadDialog dialog = new UploadDialog((UploadListener)listener, this.getHelpContext());
        dialog.show();
    }

    private void onExport() {
        ArchetypeDescriptor descriptor = (ArchetypeDescriptor)this.getObject();
        try {
            ArchetypeDescriptors descriptors = new ArchetypeDescriptors();
            descriptors.setArchetypeDescriptorsAsArray(new ArchetypeDescriptor[]{descriptor});
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            new ArchetypeDescriptorWriter(false, true).write(descriptors, (OutputStream)stream);
            String name = descriptor.getShortName() + ".adl";
            DocumentHandlers handlers = ServiceHelper.getDocumentHandlers();
            DocumentHandler handler = handlers.get(name, MIME_TYPE);
            byte[] buffer = stream.toByteArray();
            Document document = handler.create(name, (InputStream)new ByteArrayInputStream(buffer), MIME_TYPE, buffer.length);
            DownloadServlet.startDownload((org.openvpms.component.model.document.Document)document);
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    private void onReload() {
        String title = Messages.get((String)"archetype.reload.title");
        String message = Messages.get((String)"archetype.reload.message");
        ConfirmationDialog dialog = new ConfirmationDialog(title, message, ConfirmationDialog.YES_NO);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onYes() {
                ArchetypeDescriptorCacheDB cache = (ArchetypeDescriptorCacheDB)ServiceHelper.getBean(ArchetypeDescriptorCacheDB.class);
                cache.refresh();
            }
        });
        dialog.show();
    }

    private void upload(InputStream stream, String fileName) {
        try {
            if (fileName == null || fileName.toLowerCase().endsWith(".adl")) {
                this.loadArchetypes(stream);
            } else {
                this.loadAssertions(stream);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    private void loadArchetypes(InputStream stream) {
        ArchetypeDescriptors descriptors = ArchetypeDescriptors.read((InputStream)stream);
        final BatchArchetypeLoader loader = new BatchArchetypeLoader(descriptors);
        loader.setListener(new BatchProcessorListener(){

            public void completed() {
                ArchetypeCRUDWindow.this.uploaded(loader.getChanges());
            }

            public void error(Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        });
        loader.process();
    }

    private void loadAssertions(InputStream stream) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        AssertionTypeDescriptors descriptors = AssertionTypeDescriptors.read((InputStream)stream);
        for (AssertionTypeDescriptor descriptor : descriptors.getAssertionTypeDescriptors().values()) {
            service.save((IMObject)descriptor);
        }
    }

    private void uploaded(List<ArchetypeChange> changes) {
        if (!changes.isEmpty()) {
            super.onSaved((IMObject)((ArchetypeDescriptor)changes.get(0).getNewVersion()), true);
            ArrayList<ArchetypeChange> update = new ArrayList<ArchetypeChange>();
            for (ArchetypeChange change : changes) {
                if (!change.hasChangedDerivedNodes() && !change.hasAddedAssertions(BatchArchetypeUpdater.ASSERTIONS)) continue;
                update.add(change);
            }
            if (!update.isEmpty()) {
                ConfirmingBatchArchetypeUpdater updater = new ConfirmingBatchArchetypeUpdater();
                updater.confirmUpdate(update);
            }
        }
    }
}

