/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestRosterEventBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.workflow.roster.AreaRosterTableModel;
import org.openvpms.web.workspace.workflow.roster.RosterEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.springframework.beans.factory.annotation.Autowired;

public class AreaRosterTableModelTestCase
extends AbstractAppTest {
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;

    @Test
    public void testGetEvent() {
        Party location = this.practiceFactory.createLocation();
        Entity rosterArea = this.schedulingFactory.createRosterArea(location);
        Date from = DateRules.getToday();
        Date to = DateRules.getDate((Date)from, (int)7, (DateUnits)DateUnits.DAYS);
        Act act = (Act)((TestRosterEventBuilder)((TestRosterEventBuilder)((TestRosterEventBuilder)this.schedulingFactory.newRosterEvent().startTime(from)).endTime(DateRules.getDate((Date)from, (int)8, (DateUnits)DateUnits.HOURS))).location(location).schedule(rosterArea)).build();
        PropertySet event = this.createEvent(act);
        ScheduleEvents events = new ScheduleEvents(Collections.singletonList(event), 0L);
        HashMap<Entity, ScheduleEvents> eventMap = new HashMap<Entity, ScheduleEvents>();
        eventMap.put(rosterArea, events);
        RosterEventGrid grid = new RosterEventGrid(from, to, 7, eventMap);
        AreaRosterTableModel model = new AreaRosterTableModel(grid, (Context)new LocalContext(), (ScheduleColours)Mockito.mock(ScheduleColours.class));
        Assert.assertNull((Object)model.getEvent(new Cell(0, 0)));
        Assert.assertEquals((Object)event, (Object)model.getEvent(new Cell(1, 0)));
        Assert.assertNull((Object)model.getEvent(new Cell(2, 0)));
        Assert.assertNull((Object)model.getEvent(new Cell(7, 0)));
        Assert.assertNull((Object)model.getEvent(new Cell(8, 0)));
        Assert.assertNull((Object)model.getEvent(new Cell(-1, -1)));
        Assert.assertNull((Object)model.getEvent(new Cell(0, 1)));
        Assert.assertNull((Object)model.getEvent(new Cell(7, 1)));
    }

    protected PropertySet createEvent(Act event) {
        ObjectSet result = new ObjectSet();
        result.set("act.startTime", (Object)event.getActivityStartTime());
        result.set("act.endTime", (Object)event.getActivityEndTime());
        result.set("act.objectReference", (Object)event.getObjectReference());
        result.set("schedule.objectReference", (Object)this.getBean((IMObject)event).getTargetRef("schedule"));
        return result;
    }
}

