/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.i18n;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.workspace.workflow.i18n.WorkflowMessages;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowMessagesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testCoverage() {
        HashSet<String> messages = new HashSet<String>();
        HashSet<String> tests = new HashSet<String>();
        for (Method method : WorkflowMessages.class.getMethods()) {
            if (method.getReturnType() != Message.class) continue;
            messages.add(method.getName());
        }
        for (Method method : ((Object)((Object)this)).getClass().getMethods()) {
            String name = method.getName();
            if (!name.startsWith("test") || name.equals("testCoverage")) continue;
            tests.add(name);
        }
        for (String message : messages) {
            String test = "test" + message.substring(0, 1).toUpperCase() + message.substring(1);
            Assert.assertTrue((String)("No test for: " + message), (boolean)tests.contains(test));
        }
        Assert.assertEquals((long)messages.size(), (long)tests.size());
    }

    @Test
    public void testContextHasNoPractice() {
        Assert.assertEquals((Object)"Context doesn't specify a practice.", (Object)WorkflowMessages.contextHasNoPractice().getMessage());
    }

    @Test
    public void testContextHasNoLocation() {
        Assert.assertEquals((Object)"Context doesn't specify a practice location. Check the practice location for the current user.", (Object)WorkflowMessages.contextHasNoLocation().getMessage());
    }

    @Test
    public void testContextHasNoCustomer() {
        Assert.assertEquals((Object)"Context doesn't specify a customer.", (Object)WorkflowMessages.contextHasNoCustomer().getMessage());
    }

    @Test
    public void testContextHasNoPatient() {
        Assert.assertEquals((Object)"Context doesn't specify a patient.", (Object)WorkflowMessages.contextHasNoPatient().getMessage());
    }

    @Test
    public void testContextHasNoVisit() {
        Assert.assertEquals((Object)"Context doesn't specify a patient Visit.", (Object)WorkflowMessages.contextHasNoVisit().getMessage());
    }

    @Test
    public void testLocationHasNoOTCCustomer() {
        Party location = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().name("Main Clinic")).build(false);
        Assert.assertEquals((Object)"Main Clinic does not have an OTC customer defined.", (Object)WorkflowMessages.locationHasNoOTCCustomer((Party)location).getMessage());
    }

    @Test
    public void testAppointmentHasNoCustomer() {
        Assert.assertEquals((Object)"Appointment doesn't specify a customer.", (Object)WorkflowMessages.appointmentHasNoCustomer().getMessage());
    }

    @Test
    public void testAppointmentHasNoPatient() {
        Assert.assertEquals((Object)"Appointment doesn't specify a patient.", (Object)WorkflowMessages.appointmentHasNoPatient().getMessage());
    }

    @Test
    public void testTaskHasNoCustomer() {
        Assert.assertEquals((Object)"Task doesn't specify a customer.", (Object)WorkflowMessages.taskHasNoCustomer().getMessage());
    }

    @Test
    public void testTaskHasNoPatient() {
        Assert.assertEquals((Object)"Task doesn't specify a patient.", (Object)WorkflowMessages.taskHasNoPatient().getMessage());
    }
}

