/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.checkout.GetCheckOutInvoiceTask;
import org.openvpms.web.workspace.workflow.checkout.Visits;
import org.openvpms.web.workspace.workflow.consult.AbstractGetConsultInvoiceTaskTest;

public class GetCheckOutInvoiceTaskTestCase
extends AbstractGetConsultInvoiceTaskTest {
    private Visits visits;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Party customer = this.getCustomer();
        this.visits = new Visits(customer, (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class), (PatientRules)ServiceHelper.getBean(PatientRules.class), this.getArchetypeService());
    }

    @Test
    public void testGetInvoiceForMultipleCheckout() {
        Party location = TestHelper.createLocation();
        Party schedule = ScheduleTestHelper.createSchedule((Party)location);
        Party customer = this.getCustomer();
        Party patient1 = TestHelper.createPatient((Party)customer);
        Party patient2 = TestHelper.createPatient((Party)customer);
        Act appointment1 = ScheduleTestHelper.createAppointment((Date)DateRules.getToday(), (Date)DateRules.getTomorrow(), (Entity)schedule, (Party)customer, (Party)patient1);
        Act appointment2 = ScheduleTestHelper.createAppointment((Date)DateRules.getToday(), (Date)DateRules.getTomorrow(), (Entity)schedule, (Party)customer, (Party)patient2);
        Act event1 = PatientTestHelper.createEvent((Date)DateRules.getToday(), (Party)patient1, (Act[])new Act[0]);
        Act event2 = PatientTestHelper.createEvent((Date)DateRules.getToday(), (Party)patient2, (Act[])new Act[0]);
        this.visits.add(event1, appointment1);
        this.visits.add(event2, appointment2);
        SynchronousTask task = this.createGetInvoiceTask();
        TaskContext context1 = this.createCheckOutContext();
        task.execute(context1);
        Assert.assertNull((Object)context1.getObject("act.customerAccountChargesInvoice"));
        Product product = TestHelper.createProduct();
        List acts1 = FinancialTestHelper.createChargesInvoice((BigDecimal)BigDecimal.TEN, (Party)customer, (Party)patient1, (Product)product, (String)"IN_PROGRESS");
        List acts2 = FinancialTestHelper.createChargesInvoice((BigDecimal)BigDecimal.TEN, (Party)customer, (Party)patient1, (Product)product, (String)"IN_PROGRESS");
        FinancialAct invoice1 = (FinancialAct)acts1.get(0);
        FinancialAct invoice2 = (FinancialAct)acts2.get(0);
        invoice1.setActivityStartTime(DateRules.getYesterday());
        invoice2.setActivityStartTime(DateRules.getToday());
        this.save(acts1);
        this.save(acts2);
        this.addToEvent(event2, (FinancialAct)acts2.get(1));
        TaskContext context2 = this.createCheckOutContext();
        task.execute(context2);
        Assert.assertEquals((Object)invoice2, (Object)context2.getObject("act.customerAccountChargesInvoice"));
        invoice2.setStatus("POSTED");
        this.save((IMObject)invoice2);
        TaskContext context3 = this.createCheckOutContext();
        task.execute(context3);
        Assert.assertEquals((Object)invoice1, (Object)context3.getObject("act.customerAccountChargesInvoice"));
        List acts3 = FinancialTestHelper.createChargesInvoice((BigDecimal)BigDecimal.TEN, (Party)customer, (Party)patient1, (Product)product, (String)"IN_PROGRESS");
        this.save(acts3);
        FinancialAct invoice3 = (FinancialAct)acts3.get(0);
        this.addToEvent(event1, (FinancialAct)acts1.get(1));
        TaskContext context4 = this.createCheckOutContext();
        task.execute(context4);
        Assert.assertEquals((Object)invoice1, (Object)context4.getObject("act.customerAccountChargesInvoice"));
        invoice1.setStatus("POSTED");
        this.save((IMObject)invoice1);
        TaskContext context5 = this.createCheckOutContext();
        task.execute(context5);
        Assert.assertEquals((Object)invoice3, (Object)context5.getObject("act.customerAccountChargesInvoice"));
        invoice3.setStatus("POSTED");
        this.save((IMObject)invoice3);
        TaskContext context6 = this.createCheckOutContext();
        task.execute(context6);
        Assert.assertEquals((Object)invoice2, (Object)context6.getObject("act.customerAccountChargesInvoice"));
    }

    @Override
    protected SynchronousTask createGetInvoiceTask() {
        return new GetCheckOutInvoiceTask(this.visits);
    }

    private TaskContext createCheckOutContext() {
        DefaultTaskContext context = new DefaultTaskContext(new HelpContext("foo", null));
        context.addObject((IMObject)this.getCustomer());
        return context;
    }
}

