/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.charge.AbstractCustomerChargeActEditorTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.TestChargeEditor;
import org.openvpms.web.workspace.patient.charge.VisitChargeItemEditor;
import org.openvpms.web.workspace.patient.visit.VisitEditorDialog;
import org.openvpms.web.workspace.workflow.checkin.CheckInDialog;
import org.openvpms.web.workspace.workflow.checkin.CheckInEditor;
import org.openvpms.web.workspace.workflow.checkin.CheckInWorkflowRunner;
import org.springframework.beans.factory.annotation.Autowired;

public class CheckInWorkflowTestCase
extends AbstractCustomerChargeActEditorTest {
    private final List<String> errors = new ArrayList<String>();
    @Autowired
    private TestLookupFactory lookupFactory;
    private Party patient;
    private Party customer;
    private User clinician;
    private Context context;
    private Party location;
    private Entity schedule;
    private Entity workList;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.location = this.practiceFactory.createLocation();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.clinician = this.userFactory.createClinician();
        User user = this.userFactory.createUser();
        Entity taskType = this.schedulingFactory.createTaskType();
        this.schedule = this.schedulingFactory.createSchedule(this.location);
        this.workList = (Entity)this.schedulingFactory.newWorkList().addTaskType(taskType, 1, true).build();
        Entity workListView = this.schedulingFactory.createWorkListView(new Entity[]{this.workList});
        this.practiceFactory.updateLocation(this.location).addWorkListView(workListView, true).build();
        this.context = new LocalContext();
        this.context.setLocation(this.location);
        this.context.setUser(user);
        this.initErrorHandler(this.errors);
    }

    @Test
    public void testCheckInFromAppointmentNoPatient() {
        Date startTime = TestHelper.getDatetime((String)"2013-01-01 09:00:00");
        Date arrivalTime = TestHelper.getDatetime((String)"2013-01-01 08:50:00");
        Act appointment = (Act)((TestAppointmentBuilder)this.newAppointment(startTime, this.customer, null, this.clinician).notes("Appointment notes")).build();
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.setArrivalTime(arrivalTime);
        workflow.start();
        CheckInEditor editor = workflow.getCheckInEditor();
        Assert.assertNull((Object)editor.getPatient());
        editor.setPatient(this.patient);
        editor.setWorkList(this.workList);
        editor.setWeight(BigDecimal.TEN);
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getCheckInDialog(), (String)"ok");
        workflow.checkWeight(this.patient, BigDecimal.TEN, this.clinician);
        workflow.checkTask(this.workList, this.customer, this.patient, this.clinician, "PENDING", "Reason X - Appointment notes");
        VisitEditorDialog eventDialog = workflow.editVisit();
        EchoTestHelper.fireDialogButton((PopupDialog)eventDialog, (String)"ok");
        workflow.checkEvent(this.patient, this.clinician, "IN_PROGRESS", this.location);
        workflow.checkComplete(true, this.customer, this.patient, this.context);
    }

    @Test
    public void testCheckInFromAppointmentWithPatient() {
        Date startTime = TestHelper.getDatetime((String)"2013-01-01 09:00:00");
        Date arrivalTime = TestHelper.getDatetime((String)"2013-01-01 09:33:00");
        Act appointment = this.createAppointment(startTime, this.customer, this.patient, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.setArrivalTime(arrivalTime);
        this.runCheckInToVisit(workflow);
        VisitEditorDialog eventDialog = workflow.editVisit();
        EchoTestHelper.fireDialogButton((PopupDialog)eventDialog, (String)"ok");
        workflow.checkEvent(this.patient, this.clinician, "IN_PROGRESS", this.location);
        workflow.checkComplete(true, this.customer, this.patient, this.context);
    }

    @Test
    public void testCreatePatient() {
        Act appointment = this.createAppointment(this.customer, null, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        BrowserDialog<Party> dialog = workflow.selectPatient();
        EchoTestHelper.fireDialogButton(dialog, (String)"new");
        EditDialog editDialog = workflow.editPatient("Fluffy");
        Party newPatient = (Party)editDialog.getEditor().getObject();
        EchoTestHelper.fireDialogButton((PopupDialog)editDialog, (String)"ok");
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getCheckInDialog(), (String)"ok");
        workflow.checkPatient(newPatient, this.customer);
        VisitEditorDialog eventDialog = workflow.editVisit();
        EchoTestHelper.fireDialogButton((PopupDialog)eventDialog, (String)"ok");
        workflow.checkEvent(newPatient, this.clinician, "IN_PROGRESS", this.location);
        workflow.checkComplete(true, this.customer, newPatient, this.context);
    }

    @Test
    public void testCancelCreatePatient() {
        Act appointment = this.createAppointment(this.customer, null, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        BrowserDialog<Party> dialog = workflow.selectPatient();
        EchoTestHelper.fireDialogButton(dialog, (String)"new");
        EditDialog editDialog = workflow.editPatient("Fluffy");
        Party patient = (Party)editDialog.getEditor().getObject();
        EchoTestHelper.fireDialogButton((PopupDialog)editDialog, (String)"cancel");
        Assert.assertNull((Object)this.get((IMObject)patient));
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getCheckInDialog(), (String)"cancel");
        workflow.checkComplete(false, null, null, this.context);
    }

    @Test
    public void testCancelCreatePatientByUserClose() {
        Act appointment = this.createAppointment(this.customer, null, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        BrowserDialog<Party> dialog = workflow.selectPatient();
        EchoTestHelper.fireDialogButton(dialog, (String)"new");
        EditDialog editDialog = workflow.editPatient("Fluffy");
        Party patient = (Party)editDialog.getEditor().getObject();
        editDialog.userClose();
        Assert.assertNull((Object)this.get((IMObject)patient));
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getCheckInDialog(), (String)"cancel");
        workflow.checkComplete(false, null, null, this.context);
    }

    @Test
    public void testCancelCheckInDialog() {
        this.checkCancelCheckInEditDialog(false);
    }

    @Test
    public void testCancelCheckInDialogByUserClose() {
        this.checkCancelCheckInEditDialog(true);
    }

    @Test
    public void testCancelSelectWorkList() {
        Date startTime = TestHelper.getDatetime((String)"2013-01-01 09:00:00");
        Act appointment = this.createAppointment(startTime, this.customer, this.patient, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.setArrivalTime(startTime);
        workflow.start();
        BrowserDialog<Entity> browser = workflow.selectWorkList();
        browser.getBrowser().setSelected((Object)this.workList);
        EchoTestHelper.fireDialogButton(browser, (String)"cancel");
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getCheckInDialog(), (String)"ok");
        Assert.assertNull((Object)workflow.getContext().getObject("act.customerTask"));
        VisitEditorDialog eventDialog = workflow.editVisit();
        EchoTestHelper.fireDialogButton((PopupDialog)eventDialog, (String)"ok");
        workflow.checkEvent(this.patient, this.clinician, "IN_PROGRESS", this.location);
        workflow.checkComplete(true, this.customer, this.patient, this.context);
    }

    @Test
    public void testNoDefaultClinicianFromContext() {
        Act appointment = this.createAppointment(this.customer, this.patient, null);
        this.context.setClinician(this.clinician);
        this.checkClinician(appointment, null, false, this.context);
    }

    @Test
    public void testNoClinician() {
        Act appointment = this.createAppointment(this.customer, this.patient, null);
        this.checkClinician(appointment, null, false, this.context);
    }

    @Test
    public void testSetClincianInCheckInEditor() {
        Act appointment = this.createAppointment(this.customer, this.patient, this.userFactory.createClinician());
        this.checkClinician(appointment, this.clinician, true, this.context);
    }

    @Test
    public void testCancelEditEvent() {
        this.checkCancelEditEvent(false);
    }

    @Test
    public void testCancelEditEventByUserClose() {
        this.checkCancelEditEvent(true);
    }

    @Test
    public void testSkipPatientWeight() {
        Act appointment = this.createAppointment(this.customer, this.patient, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getCheckInDialog(), (String)"ok");
        IMObject weight = workflow.getContext().getObject("act.patientWeight");
        Assert.assertNull((Object)weight);
        VisitEditorDialog eventDialog = workflow.editVisit();
        EchoTestHelper.fireDialogButton((PopupDialog)eventDialog, (String)"ok");
        workflow.checkEvent(this.patient, this.clinician, "IN_PROGRESS", this.location);
        workflow.checkComplete(true, this.customer, this.patient, this.context);
    }

    @Test
    public void testCheckInWithInProgressInvoice() {
        Date date1 = TestHelper.getDatetime((String)"2012-01-01 10:00:00");
        Date date2 = TestHelper.getDatetime((String)"2012-01-02 12:00:00");
        Product medication1 = this.productFactory.createMedication();
        FinancialAct charge = (FinancialAct)this.create("act.customerAccountChargesInvoice", FinancialAct.class);
        charge.setActivityStartTime(date1);
        this.context.setCustomer(this.customer);
        this.context.setPatient(this.patient);
        this.context.setPractice(this.getPractice());
        this.context.setClinician(this.clinician);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        layoutContext.setEdit(true);
        TestChargeEditor editor = new TestChargeEditor(charge, (LayoutContext)layoutContext, false);
        editor.getComponent();
        CustomerChargeActItemEditor itemEditor1 = editor.addItem();
        itemEditor1.setStartTime(date1);
        this.setItem((CustomerChargeActEditor)editor, itemEditor1, this.patient, medication1, BigDecimal.TEN, editor.getQueue());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        FinancialAct item1 = itemEditor1.getObject();
        IMObjectBean bean = this.getBean((IMObject)item1);
        Act event1 = (Act)bean.getSource("event", Act.class);
        Assert.assertNotNull((Object)event1);
        Assert.assertEquals((Object)date1, (Object)event1.getActivityStartTime());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)event1.getStatus());
        event1.setActivityEndTime(TestHelper.getDatetime((String)"2012-01-01 11:30:00"));
        event1.setStatus("COMPLETED");
        this.save((IMObject)event1);
        Act appointment = this.createAppointment(date2, this.customer, this.patient, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.setArrivalTime(date2);
        this.runCheckInToVisit(workflow);
        Product medication2 = this.productFactory.createMedication();
        VisitChargeItemEditor itemEditor2 = workflow.addVisitInvoiceItem(this.patient, medication2);
        VisitEditorDialog eventDialog = workflow.editVisit();
        EchoTestHelper.fireDialogButton((PopupDialog)eventDialog, (String)"ok");
        Act event2 = workflow.checkEvent(this.patient, this.clinician, "IN_PROGRESS", this.location);
        workflow.checkComplete(true, this.customer, this.patient, this.context);
        FinancialAct item2 = itemEditor2.getObject();
        IMObjectBean bean2 = this.getBean((IMObject)item2);
        Assert.assertEquals((Object)event2, (Object)bean2.getSource("event"));
        Assert.assertNotEquals((Object)event1, (Object)event2);
        IMObjectBean event1Bean = this.getBean((IMObject)event1);
        IMObjectBean event2Bean = this.getBean((IMObject)event2);
        List<Act> event1Items = this.getEventItems(event1Bean);
        List<Act> event2Items = this.getEventItems(event2Bean);
        Collection inBoth = CollectionUtils.intersection(event1Items, event2Items);
        Assert.assertTrue((boolean)inBoth.isEmpty());
    }

    @Test
    public void testChangeClinicianOnInvoiceItem() {
        Date startTime = TestHelper.getDatetime((String)"2013-01-01 09:00:00");
        Act appointment = this.createAppointment(startTime, this.customer, this.patient, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.setArrivalTime(startTime);
        workflow.start();
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getCheckInDialog(), (String)"ok");
        Product product = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().fixedPrice(10)).build();
        this.addDocumentTemplate(product);
        this.addDocumentTemplate(product);
        VisitEditorDialog dialog = workflow.getVisitEditorDialog();
        dialog.getEditor().selectCharges();
        VisitChargeItemEditor itemEditor = workflow.addVisitInvoiceItem(this.patient, product);
        itemEditor.setClinician(this.clinician);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"apply");
        List<Act> documents1 = this.getDocuments(itemEditor);
        Assert.assertEquals((long)2L, (long)documents1.size());
        User clinician2 = this.userFactory.createClinician();
        itemEditor.setClinician(clinician2);
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"ok");
        List<Act> documents2 = this.getDocuments(itemEditor);
        Assert.assertEquals((long)2L, (long)documents2.size());
        Assert.assertEquals((Object)clinician2, (Object)this.getClinician(documents2.get(0)));
        Assert.assertEquals((Object)clinician2, (Object)this.getClinician(documents2.get(1)));
        workflow.checkEvent(this.patient, this.clinician, "IN_PROGRESS", this.location);
        workflow.checkComplete(true, this.customer, this.patient, this.context);
        Assert.assertTrue((boolean)this.errors.isEmpty());
    }

    @Test
    public void testUseLoggedInClinicianForClinician() {
        User clinician2 = this.userFactory.createClinician();
        this.checkUseLoggedInClinician(true, clinician2, this.clinician, clinician2);
    }

    @Test
    public void testUseLoggedInClinicianForNonClinician() {
        this.checkUseLoggedInClinician(true, this.userFactory.createUser(), this.clinician, this.clinician);
    }

    @Test
    public void testUseLoggedInClinicianDisabledForClinician() {
        User clinician2 = this.userFactory.createClinician();
        this.checkUseLoggedInClinician(false, clinician2, this.clinician, this.clinician);
    }

    @Test
    public void testUseLoggedInClinicianDisabledForNonClinician() {
        this.checkUseLoggedInClinician(false, this.userFactory.createUser(), this.clinician, this.clinician);
    }

    private List<Act> getEventItems(IMObjectBean event) {
        List items = event.getTargets("items", Act.class);
        List chargeItems = event.getTargets("chargeItems", Act.class);
        items.addAll(chargeItems);
        return items;
    }

    private Act createAppointment(Party customer, Party patient, User clinician) {
        return this.createAppointment(new Date(), customer, patient, clinician);
    }

    private Act createAppointment(Date startTime, Party customer, Party patient, User clinician) {
        return (Act)this.newAppointment(startTime, customer, patient, clinician).build();
    }

    private TestAppointmentBuilder newAppointment(Date startTime, Party customer, Party patient, User clinician) {
        Lookup reason = this.lookupFactory.getLookup(ScheduleArchetypes.VISIT_REASON, "REASON_X", "Reason X");
        return (TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(startTime)).schedule(this.schedule).appointmentType(this.schedulingFactory.createAppointmentType()).reason(reason.getCode())).customer(customer)).patient(patient)).clinician(clinician)).status("PENDING");
    }

    private void checkUseLoggedInClinician(boolean enabled, User user, User appointmentClinician, User expectedClinician) {
        this.practiceFactory.updatePractice(this.getPractice()).useLoggedInClinician(enabled).build(false);
        Date startTime = TestHelper.getDatetime((String)"2018-01-01 09:00:00");
        Date arrivalTime = TestHelper.getDatetime((String)"2018-01-01 09:33:00");
        Act appointment = this.createAppointment(startTime, this.customer, this.patient, appointmentClinician);
        this.context.setUser(user);
        this.context.setClinician(this.userFactory.createClinician());
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.setArrivalTime(arrivalTime);
        this.runCheckInToVisit(workflow);
        VisitEditorDialog eventDialog = workflow.editVisit();
        EchoTestHelper.fireDialogButton((PopupDialog)eventDialog, (String)"ok");
        workflow.checkEvent(this.patient, expectedClinician, "IN_PROGRESS", this.location);
        workflow.checkInvoice(expectedClinician, BigDecimal.ZERO, "IN_PROGRESS", true);
        workflow.checkComplete(true, this.customer, this.patient, this.context);
    }

    private void checkCancelCheckInEditDialog(boolean userClose) {
        Act appointment = this.createAppointment(this.customer, null, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        workflow.start();
        CheckInDialog dialog = workflow.getCheckInDialog();
        CheckInEditor editor = dialog.getEditor();
        editor.setPatient(this.patient);
        EchoTestHelper.cancelDialog((PopupDialog)dialog, (boolean)userClose);
        workflow.checkComplete(false, null, null, this.context);
    }

    private void checkCancelEditEvent(boolean userClose) {
        Act appointment = this.createAppointment(this.customer, this.patient, this.clinician);
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), this.context);
        this.runCheckInToVisit(workflow);
        VisitEditorDialog eventDialog = workflow.editVisit();
        EchoTestHelper.cancelDialog((PopupDialog)eventDialog, (boolean)userClose);
        workflow.checkEvent(this.patient, this.clinician, "IN_PROGRESS", this.location);
        workflow.checkInvoice(this.clinician, BigDecimal.ZERO, "IN_PROGRESS", false);
        workflow.checkComplete(false, null, null, this.context);
    }

    private void runCheckInToVisit(CheckInWorkflowRunner workflow) {
        workflow.start();
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getCheckInDialog(), (String)"ok");
    }

    private void checkClinician(Act appointment, User clinician, boolean setClinician, Context context) {
        CheckInWorkflowRunner workflow = new CheckInWorkflowRunner(appointment, this.getPractice(), context);
        workflow.setArrivalTime(new Date());
        workflow.start();
        CheckInEditor editor = workflow.getCheckInEditor();
        editor.setWorkList(this.workList);
        editor.setWeight(BigDecimal.TEN);
        if (setClinician) {
            editor.setClinician(clinician);
        }
        EchoTestHelper.fireDialogButton((PopupDialog)workflow.getCheckInDialog(), (String)"ok");
        VisitEditorDialog eventDialog = workflow.editVisit();
        EchoTestHelper.fireDialogButton((PopupDialog)eventDialog, (String)"ok");
        workflow.checkWeight(this.patient, BigDecimal.TEN, clinician);
        workflow.checkTask(this.workList, this.customer, this.patient, clinician, "PENDING", "Reason X");
        workflow.checkEvent(this.patient, clinician, "IN_PROGRESS", this.location);
        workflow.checkInvoice(clinician, BigDecimal.ZERO, "IN_PROGRESS", true);
        workflow.checkComplete(true, this.customer, this.patient, context);
    }

    private List<Act> getDocuments(VisitChargeItemEditor itemEditor) {
        IMObjectBean bean = this.getBean((IMObject)itemEditor.getObject());
        return bean.getTargets("documents", Act.class);
    }

    private User getClinician(Act act) {
        IMObjectBean bean = this.getBean((IMObject)act);
        return (User)bean.getTarget("clinician", User.class);
    }
}

