/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.reminder;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.macro.Macros;
import org.openvpms.macro.impl.MacroTestHelper;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.workspace.workflow.appointment.reminder.AppointmentReminderEvaluator;
import org.openvpms.web.workspace.workflow.appointment.reminder.AppointmentReminderException;
import org.springframework.beans.factory.annotation.Autowired;

public class AppointmentReminderEvaluatorTestCase
extends ArchetypeServiceTest {
    @Autowired
    private Macros macros;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    private AppointmentReminderEvaluator evaluator;
    private Party practice;
    private Party location;
    private Act act;

    @Before
    public void setUp() {
        SMSTemplateEvaluator smsEvaluator = new SMSTemplateEvaluator((ArchetypeService)this.getArchetypeService(), this.getLookupService(), this.macros);
        this.evaluator = new AppointmentReminderEvaluator((ArchetypeService)this.getArchetypeService(), smsEvaluator);
        this.practice = (Party)((TestPracticeBuilder)this.practiceFactory.newPractice().name("Vets R Us")).build(false);
        this.location = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().name("Vets R Us - Cowes")).build();
        Party customer = this.customerFactory.createCustomer("Pippi", "Smith");
        Party patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Fido")).owner(customer).build();
        this.act = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime("2015-11-28 09:00:00")).endTime("2015-11-28 09:30:00")).schedule(this.schedulingFactory.createSchedule(this.location)).customer(customer)).patient(patient)).appointmentType(this.schedulingFactory.createAppointmentType("Vaccination")).build();
    }

    @Test
    public void testXPathExpression() {
        String expression = "concat('Reminder: ', $patient.name, ' has a ', $appointment.appointmentType.entity.name, ' appointment at ', $location.name, ' on ', date:formatDate($appointment.startTime, 'short'))";
        Entity template = this.createTemplate("XPATH", expression);
        String value = this.evaluator.evaluate(template, this.act, this.location, this.practice);
        Assert.assertEquals((Object)"Reminder: Fido has a Vaccination appointment at Vets R Us - Cowes on 28/11/15", (Object)value);
    }

    @Test
    public void testXPathVariables() {
        this.checkXPathExpression("$patient.name", "Fido");
        this.checkXPathExpression("$location.name", "Vets R Us - Cowes");
        this.checkXPathExpression("$customer.firstName", "Pippi");
        this.checkXPathExpression("$practice.name", "Vets R Us");
    }

    @Test
    public void testXPathException() {
        try {
            Entity template = this.createTemplate("XPATH", "$badexpression");
            this.evaluator.evaluate(template, this.act, this.location, this.practice);
            Assert.fail((String)"Expected evaluation to throw an exception");
        }
        catch (AppointmentReminderException expected) {
            Assert.assertEquals((Object)"Failed to evaluate the expression in XPATH template", (Object)expected.getMessage());
        }
    }

    @Test
    public void testMacroExpression() {
        MacroTestHelper.createMacro((String)"@patient", (String)"$patient.name");
        MacroTestHelper.createMacro((String)"@location", (String)"$location.name");
        MacroTestHelper.createMacro((String)"@startDate", (String)"date:formatDate($appointment.startTime, 'short')");
        String expression = "Reminder: @patient has an appointment at @location on @startDate";
        Entity template = this.createTemplate("MACRO", expression);
        String value = this.evaluator.evaluate(template, this.act, this.location, this.practice);
        Assert.assertEquals((Object)"Reminder: Fido has an appointment at Vets R Us - Cowes on 28/11/15", (Object)value);
    }

    @Test
    public void testMacroException() {
        MacroTestHelper.createMacro((String)"@badexpression", (String)"concat(");
        try {
            Entity template = this.createTemplate("MACRO", "@badexpression");
            this.evaluator.evaluate(template, this.act, this.location, this.practice);
            Assert.fail((String)"Expected evaluation to throw an exception");
        }
        catch (AppointmentReminderException expected) {
            Assert.assertEquals((Object)"Failed to evaluate the expression in MACRO template", (Object)expected.getMessage());
        }
    }

    private void checkXPathExpression(String expression, String expected) {
        Entity template = this.createTemplate("XPATH", expression);
        String value = this.evaluator.evaluate(template, this.act, this.location, this.practice);
        Assert.assertEquals((Object)expected, (Object)value);
    }

    private Entity createTemplate(String type, String expression) {
        Entity template = (Entity)this.create("entity.documentTemplateSMSAppointment", Entity.class);
        IMObjectBean bean = this.getBean((IMObject)template);
        bean.setValue("name", (Object)(type + " template"));
        bean.setValue("contentType", (Object)type);
        bean.setValue("content", (Object)expression);
        return template;
    }
}

