/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentGridTest;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGridView;
import org.openvpms.web.workspace.workflow.appointment.MultiScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.SingleScheduleGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.springframework.beans.factory.annotation.Autowired;

public class AppointmentGridViewTestCase
extends AbstractAppointmentGridTest {
    @Autowired
    private AppointmentRules rules;
    @Autowired
    private RosterService rosterService;
    private TimeZone defaultTimeZone;

    @Before
    public void setUp() {
        this.defaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("Australia/Melbourne"));
        super.setUp();
    }

    @After
    public void tearDown() {
        TimeZone.setDefault(this.defaultTimeZone);
        super.tearDown();
    }

    @Test
    public void testDaylightSavingsForSingle9to5ScheduleGrid() {
        Date daylightSavingsStart = TestHelper.getDate((String)"2019-10-06");
        Date daylightSavingsEnd = TestHelper.getDate((String)"2020-04-05");
        Entity schedule = this.createSchedule(15, "09:00", "17:00");
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule});
        ScheduleEvents events = new ScheduleEvents(Collections.emptyList(), 0L);
        SingleScheduleGrid grid1 = new SingleScheduleGrid(scheduleView, daylightSavingsStart, schedule, events, this.rules, this.rosterService);
        AppointmentGridView view1 = new AppointmentGridView((AppointmentGrid)grid1, 540, 1020, this.rules, this.rosterService);
        Assert.assertEquals((long)32L, (long)view1.getSlots());
        this.checkSlot((AppointmentGrid)view1, schedule, 0, "2019-10-06T09:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule, 1, "2019-10-06T09:15:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule, 2, "2019-10-06T09:30:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        SingleScheduleGrid grid2 = new SingleScheduleGrid(scheduleView, daylightSavingsEnd, schedule, events, this.rules, this.rosterService);
        AppointmentGridView view2 = new AppointmentGridView((AppointmentGrid)grid2, 540, 1020, this.rules, this.rosterService);
        Assert.assertEquals((long)32L, (long)view2.getSlots());
        this.checkSlot((AppointmentGrid)view2, schedule, 0, "2020-04-05T09:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule, 1, "2020-04-05T09:15:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule, 2, "2020-04-05T09:30:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
    }

    @Test
    public void testDaylightSavingsForMutli9to5ScheduleGrid() {
        Date daylightSavingsStart = TestHelper.getDate((String)"2019-10-06");
        Date daylightSavingsEnd = TestHelper.getDate((String)"2020-04-05");
        Entity schedule1 = this.createSchedule(15, "09:00", "17:00");
        Entity schedule2 = this.createSchedule(15, "09:00", "17:00");
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule1, schedule2});
        ScheduleEvents emptyEvents = new ScheduleEvents(Collections.emptyList(), 0L);
        HashMap<Entity, ScheduleEvents> map = new HashMap<Entity, ScheduleEvents>();
        map.put(schedule1, emptyEvents);
        map.put(schedule2, emptyEvents);
        MultiScheduleGrid grid1 = new MultiScheduleGrid(scheduleView, daylightSavingsStart, map, this.rules, this.rosterService);
        AppointmentGridView view1 = new AppointmentGridView((AppointmentGrid)grid1, 540, 1020, this.rules, this.rosterService);
        Assert.assertEquals((long)32L, (long)view1.getSlots());
        this.checkSlot((AppointmentGrid)view1, schedule1, 0, "2019-10-06T09:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule2, 0, "2019-10-06T09:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule1, 1, "2019-10-06T09:15:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule2, 1, "2019-10-06T09:15:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule1, 2, "2019-10-06T09:30:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule2, 2, "2019-10-06T09:30:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        MultiScheduleGrid grid2 = new MultiScheduleGrid(scheduleView, daylightSavingsEnd, map, this.rules, this.rosterService);
        AppointmentGridView view2 = new AppointmentGridView((AppointmentGrid)grid2, 540, 1020, this.rules, this.rosterService);
        Assert.assertEquals((long)32L, (long)view2.getSlots());
        this.checkSlot((AppointmentGrid)view2, schedule1, 0, "2020-04-05T09:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule2, 0, "2020-04-05T09:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule1, 1, "2020-04-05T09:15:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule2, 1, "2020-04-05T09:15:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule1, 2, "2020-04-05T09:30:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule2, 2, "2020-04-05T09:30:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
    }

    @Test
    public void test24HourSingleScheduleDuringDaylightSaving() {
        Date daylightSavingsStart = TestHelper.getDate((String)"2019-10-06");
        Date daylightSavingsEnd = TestHelper.getDate((String)"2020-04-05");
        Entity schedule = this.createSchedule(60, "00:00", "24:00");
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{schedule});
        Act appointment1 = this.createAppointment("2019-10-06 02:00", "2019-10-06 02:30", schedule);
        ScheduleEvents events1 = new ScheduleEvents(Collections.singletonList(this.createEvent(appointment1)), 0L);
        SingleScheduleGrid grid1 = new SingleScheduleGrid(scheduleView, daylightSavingsStart, schedule, events1, this.rules, this.rosterService);
        AppointmentGridView view1 = new AppointmentGridView((AppointmentGrid)grid1, 0, 1440, this.rules, this.rosterService);
        Assert.assertEquals((long)23L, (long)view1.getSlots());
        this.checkSlot((AppointmentGrid)view1, schedule, 0, "2019-10-06T00:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule, 1, "2019-10-06T01:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule, 2, "2019-10-06T03:00:00+11:00", appointment1, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)view1, schedule, 3, "2019-10-06T04:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, schedule, 22, "2019-10-06T23:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        Act appointment2 = this.createAppointment("2020-04-05 02:00", "2020-04-05 02:30", schedule);
        ScheduleEvents events2 = new ScheduleEvents(Collections.singletonList(this.createEvent(appointment2)), 0L);
        SingleScheduleGrid grid2 = new SingleScheduleGrid(scheduleView, daylightSavingsEnd, schedule, events2, this.rules, this.rosterService);
        AppointmentGridView view2 = new AppointmentGridView((AppointmentGrid)grid2, 0, 1440, this.rules, this.rosterService);
        Assert.assertEquals((long)25L, (long)view2.getSlots());
        this.checkSlot((AppointmentGrid)view2, schedule, 0, "2020-04-05T00:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule, 1, "2020-04-05T01:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule, 2, "2020-04-05T02:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule, 3, "2020-04-05T02:00:00+10:00", appointment2, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)view2, schedule, 4, "2020-04-05T03:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, schedule, 24, "2020-04-05T23:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
    }

    @Test
    public void test24HourMutliScheduleDuringDaylightSaving() {
        Date daylightSavingsStart = TestHelper.getDate((String)"2019-10-06");
        Date daylightSavingsEnd = TestHelper.getDate((String)"2020-04-05");
        Entity scheduleA = this.createSchedule(60, "00:00", "24:00");
        Entity scheduleB = this.createSchedule(60, "00:00", "24:00");
        Entity scheduleView = this.schedulingFactory.createScheduleView(new Entity[]{scheduleA, scheduleB});
        Act appointment1a = this.createAppointment("2019-10-06 02:00", "2019-10-06 02:30", scheduleA);
        Act appointment1b = this.createAppointment("2019-10-06 02:00", "2019-10-06 03:00", scheduleB);
        HashMap<Entity, ScheduleEvents> map1 = new HashMap<Entity, ScheduleEvents>();
        map1.put(scheduleA, new ScheduleEvents(Collections.singletonList(this.createEvent(appointment1a)), 0L));
        map1.put(scheduleB, new ScheduleEvents(Collections.singletonList(this.createEvent(appointment1b)), 0L));
        MultiScheduleGrid grid1 = new MultiScheduleGrid(scheduleView, daylightSavingsStart, map1, this.rules, this.rosterService);
        AppointmentGridView view1 = new AppointmentGridView((AppointmentGrid)grid1, 0, 1440, this.rules, this.rosterService);
        Assert.assertEquals((long)23L, (long)view1.getSlots());
        this.checkSlot((AppointmentGrid)view1, scheduleA, 0, "2019-10-06T00:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, scheduleA, 1, "2019-10-06T01:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, scheduleA, 2, "2019-10-06T03:00:00+11:00", appointment1a, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)view1, scheduleA, 3, "2019-10-06T04:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view1, scheduleA, 22, "2019-10-06T23:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        Act appointment2a = this.createAppointment("2020-04-05 02:00", "2020-04-05 02:30", scheduleA);
        Act appointment2b = this.createAppointment("2020-04-05 02:00", "2020-04-05 03:00", scheduleB);
        HashMap<Entity, ScheduleEvents> map2 = new HashMap<Entity, ScheduleEvents>();
        map2.put(scheduleA, new ScheduleEvents(Collections.singletonList(this.createEvent(appointment2a)), 0L));
        map2.put(scheduleB, new ScheduleEvents(Collections.singletonList(this.createEvent(appointment2b)), 0L));
        MultiScheduleGrid grid2 = new MultiScheduleGrid(scheduleView, daylightSavingsEnd, map2, this.rules, this.rosterService);
        AppointmentGridView view2 = new AppointmentGridView((AppointmentGrid)grid2, 0, 1440, this.rules, this.rosterService);
        Assert.assertEquals((long)25L, (long)view2.getSlots());
        this.checkSlot((AppointmentGrid)view2, scheduleA, 0, "2020-04-05T00:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, scheduleA, 1, "2020-04-05T01:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, scheduleA, 2, "2020-04-05T02:00:00+11:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, scheduleA, 3, "2020-04-05T02:00:00+10:00", appointment2a, 1, ScheduleEventGrid.Availability.BUSY);
        this.checkSlot((AppointmentGrid)view2, scheduleA, 4, "2020-04-05T03:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
        this.checkSlot((AppointmentGrid)view2, scheduleA, 24, "2020-04-05T23:00:00+10:00", null, 0, ScheduleEventGrid.Availability.FREE);
    }
}

