/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.supplier.DeliveryStatus;
import org.openvpms.archetype.rules.supplier.SupplierTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.supplier.order.OrderEditor;
import org.openvpms.web.workspace.supplier.order.OrderItemEditor;

public class OrderEditorTestCase
extends AbstractAppTest {
    private Party practice;

    @Before
    public void setUp() {
        super.setUp();
        this.practice = TestHelper.getPractice();
    }

    @Test
    public void testTaxRateChangeForInProgressOrder() {
        BigDecimal amount = new BigDecimal("20");
        FinancialAct order = this.createOrder(amount, "IN_PROGRESS");
        this.checkEquals(amount, order.getTotal());
        this.checkEquals(BigDecimal.ZERO, order.getTaxAmount());
        this.practice.addClassification(TestHelper.createTaxType((BigDecimal)new BigDecimal("10")));
        this.edit(order);
        this.checkEquals(new BigDecimal("22"), order.getTotal());
        this.checkEquals(new BigDecimal("2"), order.getTaxAmount());
    }

    @Test
    public void testTaxRateChangeForPostedOrder() {
        BigDecimal amount = new BigDecimal("10");
        FinancialAct order = this.createOrder(amount, "POSTED");
        this.checkEquals(amount, order.getTotal());
        this.checkEquals(BigDecimal.ZERO, order.getTaxAmount());
        this.practice.addClassification(TestHelper.createTaxType((BigDecimal)new BigDecimal("10")));
        this.edit(order);
        this.checkEquals(BigDecimal.TEN, order.getTotal());
        this.checkEquals(BigDecimal.ZERO, order.getTaxAmount());
    }

    @Test
    public void testChangeCancelledQuantity() {
        Party supplier = TestHelper.createSupplier();
        Party stockLocation = SupplierTestHelper.createStockLocation();
        Product product1 = TestHelper.createProduct();
        Product product2 = TestHelper.createProduct();
        FinancialAct item1 = SupplierTestHelper.createOrderItem((Product)product1, (BigDecimal)BigDecimal.valueOf(20L), (int)1, (String)"BOX", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ONE);
        FinancialAct item2 = SupplierTestHelper.createOrderItem((Product)product2, (BigDecimal)MathRules.ONE_HUNDRED, (int)1, (String)"BOX", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ONE);
        List order = SupplierTestHelper.createOrder((Party)supplier, (Party)stockLocation, (FinancialAct[])new FinancialAct[]{item1, item2});
        IMObjectBean item1Bean = this.getBean((IMObject)item1);
        item1Bean.setValue("receivedQuantity", (Object)20);
        ((FinancialAct)order.get(0)).setStatus2(DeliveryStatus.PART.toString());
        this.save(order);
        OrderEditor editor = this.createEditor((FinancialAct)order.get(0));
        OrderItemEditor item1Editor = this.getItemEditor(editor, item1);
        item1Editor.setCancelledQuantity(BigDecimal.valueOf(20L));
        Assert.assertEquals((Object)DeliveryStatus.PART.toString(), (Object)editor.getDeliveryStatus());
        OrderItemEditor item2Editor = this.getItemEditor(editor, item2);
        item2Editor.setCancelledQuantity(MathRules.ONE_HUNDRED);
        Assert.assertEquals((Object)DeliveryStatus.FULL.toString(), (Object)editor.getDeliveryStatus());
        item2Editor.setCancelledQuantity(BigDecimal.ZERO);
        Assert.assertEquals((Object)DeliveryStatus.PART.toString(), (Object)editor.getDeliveryStatus());
    }

    private OrderItemEditor getItemEditor(OrderEditor editor, FinancialAct item) {
        ActRelationshipCollectionEditor items = editor.getItems();
        for (Act act : items.getCurrentActs()) {
            if (!act.equals(item)) continue;
            return (OrderItemEditor)items.getEditor((IMObject)act);
        }
        throw new IllegalStateException("item not found");
    }

    private void edit(FinancialAct order) {
        OrderEditor editor = this.createEditor(order);
        editor.save();
    }

    private OrderEditor createEditor(FinancialAct order) {
        User author = TestHelper.createUser();
        LocalContext context = new LocalContext();
        context.setPractice(this.practice);
        context.setUser(author);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        OrderEditor editor = new OrderEditor(order, null, (LayoutContext)layoutContext);
        editor.getComponent();
        return editor;
    }

    private FinancialAct createOrder(BigDecimal amount, String status) {
        Product product = TestHelper.createProduct();
        Party supplier = TestHelper.createSupplier();
        Party stockLocation = SupplierTestHelper.createStockLocation();
        List acts = SupplierTestHelper.createOrder((BigDecimal)amount, (Party)supplier, (Party)stockLocation, (Product)product);
        FinancialAct order = (FinancialAct)acts.get(0);
        order.setStatus(status);
        this.save(acts);
        return order;
    }
}

