/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.supplier.AbstractSupplierStockItemEditorTest;
import org.openvpms.web.workspace.supplier.SupplierStockItemEditor;
import org.openvpms.web.workspace.supplier.delivery.DeliveryItemEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class DeliveryItemEditorTestCase
extends AbstractSupplierStockItemEditorTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    private LayoutContext context;
    private Lookup each;
    private Lookup box;

    @Before
    public void setUp() {
        super.setUp();
        this.context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        this.each = this.lookupFactory.createUnitOfMeasure("EACH");
        this.box = this.lookupFactory.createUnitOfMeasure("BOX");
    }

    @Test
    public void testFactory() {
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        IMObjectEditor editor1 = this.factory.create(this.create("act.supplierDeliveryItem", FinancialAct.class), (LayoutContext)layoutContext);
        Assert.assertTrue((boolean)(editor1 instanceof DeliveryItemEditor));
        IMObjectEditor editor2 = this.factory.create(this.create("act.supplierReturnItem", FinancialAct.class), (LayoutContext)layoutContext);
        Assert.assertTrue((boolean)(editor2 instanceof DeliveryItemEditor));
    }

    @Test
    public void testValidation() {
        Act delivery = (Act)this.create("act.supplierDelivery", Act.class);
        FinancialAct item = (FinancialAct)this.create("act.supplierDeliveryItem", FinancialAct.class);
        DeliveryItemEditor editor = new DeliveryItemEditor(item, delivery, this.context);
        delivery.setStatus("POSTED");
        Assert.assertFalse((boolean)editor.isValid());
        Product product = this.productFactory.createMedication();
        editor.setProduct(product);
        editor.setPackageSize(Integer.valueOf(1));
        editor.setPackageUnits(this.each.getCode());
        Assert.assertTrue((boolean)editor.isValid());
        editor.getProperty("packageSize").setValue(null);
        editor.setPackageUnits(null);
        Assert.assertFalse((boolean)editor.isValid());
    }

    @Test
    public void testProductUpdateForManualDelivery() {
        Party supplier = this.supplierFactory.createSupplier();
        Act delivery = this.createDelivery(supplier);
        Product product = this.productFactory.createMedication();
        this.createProductSupplier(product, supplier, "A1", 2, this.box.getCode(), BigDecimal.TEN, BigDecimal.TEN);
        FinancialAct item = this.createDeliveryItem();
        DeliveryItemEditor editor = new DeliveryItemEditor(item, delivery, this.context);
        editor.setStockLocation(this.practiceFactory.createStockLocation(new Party[0]));
        Assert.assertTrue((boolean)editor.isValid());
        editor.setProduct(product);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertEquals((Object)"A1", (Object)editor.getReorderCode());
        Assert.assertEquals((long)2L, (long)editor.getPackageSize());
        Assert.assertEquals((Object)this.box.getCode(), (Object)editor.getPackageUnits());
        this.checkEquals(BigDecimal.TEN, editor.getQuantity());
        this.checkEquals(BigDecimal.TEN, editor.getUnitPrice());
        this.checkEquals(BigDecimal.TEN, editor.getListPrice());
    }

    @Test
    public void testProductUpdateForESCIDelivery() {
        Party supplier = this.supplierFactory.createSupplier();
        Act delivery = this.createDelivery(supplier);
        Product product = this.productFactory.createMedication();
        this.createProductSupplier(product, supplier, "A1", 2, this.box.getCode(), BigDecimal.TEN, BigDecimal.TEN);
        FinancialAct item = (FinancialAct)this.create("act.supplierDeliveryItem", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setValue("supplierInvoiceLineId", (Object)"1");
        DeliveryItemEditor editor = new DeliveryItemEditor(item, delivery, this.context);
        editor.setUnitPrice(new BigDecimal(12));
        this.populate((SupplierStockItemEditor)editor, product, BigDecimal.TEN, "B1", 1, this.each.getCode(), new BigDecimal(12));
        editor.setStockLocation(this.practiceFactory.createStockLocation(new Party[0]));
        Assert.assertTrue((boolean)editor.isValid());
        editor.setProduct(product);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertEquals((Object)"B1", (Object)editor.getReorderCode());
        Assert.assertEquals((long)1L, (long)editor.getPackageSize());
        Assert.assertEquals((Object)this.each.getCode(), (Object)editor.getPackageUnits());
        this.checkEquals(BigDecimal.TEN, editor.getQuantity());
        this.checkEquals(new BigDecimal("12"), editor.getUnitPrice());
        this.checkEquals(new BigDecimal("12"), editor.getListPrice());
    }

    @Test
    public void testSupplierRelationshipNotCreatedOrUpdatedForDelivery() {
        Party supplier = this.supplierFactory.createSupplier();
        Act delivery = this.createDelivery(supplier);
        Product product = this.productFactory.createMedication();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        FinancialAct item1 = this.createDeliveryItem();
        DeliveryItemEditor editor1 = new DeliveryItemEditor(item1, delivery, this.context);
        editor1.setStockLocation(stockLocation);
        editor1.setProduct(product);
        editor1.setPackageSize(Integer.valueOf(1));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        product = (Product)this.get((IMObject)product);
        supplier = (Party)this.get((IMObject)supplier);
        Assert.assertTrue((boolean)this.productRules.getProductSuppliers(product, supplier).isEmpty());
        this.createProductSupplier(product, supplier, "A1", 2, this.box.getCode(), BigDecimal.TEN, BigDecimal.TEN);
        FinancialAct item2 = this.createDeliveryItem();
        DeliveryItemEditor editor2 = new DeliveryItemEditor(item2, delivery, this.context);
        editor2.setStockLocation(stockLocation);
        editor2.setProduct(product);
        editor2.setListPrice(new BigDecimal("20"));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor2));
        this.checkProductSupplier(product, supplier, "A1", 2, this.box.getCode(), BigDecimal.TEN);
    }

    @Test
    public void testCreateProductSupplierRelationship() {
        Act deliveryReturn = (Act)this.create("act.supplierReturn", Act.class);
        Party supplier = this.supplierFactory.createSupplier();
        IMObjectBean bean = this.getBean((IMObject)deliveryReturn);
        bean.setTarget("supplier", (IMObject)supplier);
        FinancialAct item = (FinancialAct)this.create("act.supplierReturnItem", FinancialAct.class);
        DeliveryItemEditor editor = new DeliveryItemEditor(item, deliveryReturn, this.context);
        this.checkCreateProductSupplierRelationship((SupplierStockItemEditor)editor, supplier);
    }

    @Test
    public void testUpdateProductSupplierRelationship() {
        Party supplier = this.supplierFactory.createSupplier();
        Act deliveryReturn = (Act)this.create("act.supplierReturn", Act.class);
        IMObjectBean bean = this.getBean((IMObject)deliveryReturn);
        bean.setTarget("supplier", (IMObject)supplier);
        FinancialAct item = (FinancialAct)this.create("act.supplierReturnItem", FinancialAct.class);
        DeliveryItemEditor editor = new DeliveryItemEditor(item, deliveryReturn, this.context);
        this.checkUpdateProductSupplierRelationship((SupplierStockItemEditor)editor);
    }

    private Act createDelivery(Party supplier) {
        Act delivery = (Act)this.create("act.supplierDelivery", Act.class);
        IMObjectBean bean = this.getBean((IMObject)delivery);
        bean.setTarget("supplier", (IMObject)supplier);
        return delivery;
    }

    private FinancialAct createDeliveryItem() {
        FinancialAct item = (FinancialAct)this.create("act.supplierDeliveryItem", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setValue("reorderCode", (Object)"B1");
        bean.setValue("packageSize", (Object)1);
        bean.setValue("packageUnits", (Object)this.each.getCode());
        bean.setValue("quantity", (Object)10);
        bean.setValue("unitPrice", (Object)12);
        bean.setValue("listPrice", (Object)12);
        bean.setValue("tax", (Object)12);
        return item;
    }
}

