/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.AbstractReminderBatchProcessorTest;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemQuerySource;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemSource;
import org.openvpms.web.workspace.reporting.reminder.ReminderListBatchProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderListProcessor;
import org.openvpms.web.workspace.reporting.reminder.Statistics;
import org.openvpms.web.workspace.reporting.reminder.TestCommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.TestReminderItemQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ReminderListBatchProcessorTestCase
extends AbstractReminderBatchProcessorTest {
    private Party practice;
    private Party location;
    private ReminderTypes reminderTypes;
    @Autowired
    private ReminderRules reminderRules;
    @Autowired
    private PatientRules patientRules;
    private ReminderConfiguration config;
    private Entity reminderType1;
    private Entity reminderType2;
    private Date due;
    private Act reminderA1;
    private Act itemA1;
    private Act reminderA2;
    private Act itemA2;
    private Act reminderB1;
    private Act itemB1;
    private Party patientC;
    private Act reminderC1;
    private Act itemC1;
    private ReminderItemQuerySource source;
    private TestCommunicationLogger communicationLogger;

    @Before
    public void setUp() {
        this.practice = this.practiceFactory.getPractice();
        this.location = this.practiceFactory.createLocation();
        IArchetypeService service = this.getArchetypeService();
        this.reminderTypes = new ReminderTypes((ArchetypeService)service);
        this.config = new ReminderConfiguration(this.create("entity.reminderConfigurationType"), (ArchetypeService)service);
        Party customer1 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().title("MS").firstName("J").lastName("Smith").addAddress("103 Stafford Drive", "SALE", "VIC", "3085", new String[0])).build();
        Party patientA = this.patientFactory.createPatient("Fido", customer1);
        Party patientB = this.patientFactory.createPatient("Spot", customer1);
        Party customer2 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().title("MR").firstName("K").lastName("Aardvark").addAddress("91 Smith Rd", "KONGWAK", "VIC", "3086", new String[0])).build();
        this.patientC = this.patientFactory.createPatient("Fluffy", customer2);
        this.reminderType1 = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.MONTHS).newCount().count(0).interval(0, DateUnits.WEEKS).add().newCount().count(1).interval(1, DateUnits.WEEKS).add().build();
        this.reminderType2 = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.MONTHS).newCount().count(0).interval(0, DateUnits.WEEKS).add().newCount().count(1).interval(1, DateUnits.MONTHS).add().build();
        Date send = DateRules.getToday();
        this.due = DateRules.getTomorrow();
        this.itemA1 = this.reminderFactory.createListReminder(send, this.due);
        this.itemA2 = this.reminderFactory.createListReminder(send, this.due);
        this.reminderA1 = this.reminderFactory.createReminder(this.due, patientA, this.reminderType1, new Act[]{this.itemA1});
        this.reminderA2 = this.reminderFactory.createReminder(this.due, patientA, this.reminderType2, new Act[]{this.itemA2});
        this.itemB1 = this.reminderFactory.createListReminder(send, this.due);
        this.reminderB1 = this.reminderFactory.createReminder(this.due, patientB, this.reminderType1, new Act[]{this.itemB1});
        this.itemC1 = this.reminderFactory.createListReminder(send, this.due);
        this.reminderC1 = this.reminderFactory.createReminder(this.due, this.patientC, this.reminderType2, new Act[]{this.itemC1});
        TestReminderItemQueryFactory factory = new TestReminderItemQueryFactory("act.patientReminderItemList", this.itemA1, this.itemA2, this.itemB1, this.itemC1);
        this.source = new ReminderItemQuerySource((ReminderItemQueryFactory)factory, this.reminderTypes, this.config);
        this.communicationLogger = new TestCommunicationLogger((ArchetypeService)service);
    }

    @Test
    public void testList() {
        TestReminderListProcessor processor = this.createProcessor();
        ReminderListBatchProcessor batchProcessor = new ReminderListBatchProcessor((ReminderItemSource)this.source, (ReminderListProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkCompleted(this.itemA1, this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, oneWeek);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<Act> printed = processor.getPrinted();
        Assert.assertEquals((long)4L, (long)printed.size());
        Assert.assertEquals((Object)this.reminderC1, (Object)printed.get(0));
        Assert.assertEquals((Object)this.reminderA1, (Object)printed.get(1));
        Assert.assertEquals((Object)this.reminderA2, (Object)printed.get(2));
        Assert.assertEquals((Object)this.reminderB1, (Object)printed.get(3));
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testCancel() {
        ((TestPatientBuilder)this.patientFactory.updatePatient(this.patientC).active(false)).build();
        TestReminderListProcessor processor = this.createProcessor();
        ReminderListBatchProcessor batchProcessor = new ReminderListBatchProcessor((ReminderItemSource)this.source, (ReminderListProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkCompleted(this.itemA1, this.itemA2, this.itemB1);
        this.checkStatus("CANCELLED", "Patient is inactive", this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, oneWeek);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<Act> printed = processor.getPrinted();
        Assert.assertEquals((long)3L, (long)printed.size());
        Assert.assertEquals((Object)this.reminderA1, (Object)printed.get(0));
        Assert.assertEquals((Object)this.reminderA2, (Object)printed.get(1));
        Assert.assertEquals((Object)this.reminderB1, (Object)printed.get(2));
        Assert.assertEquals((long)3L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)1L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)1L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)3L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testPrintFailure() {
        TestReminderListProcessor processor = this.createProcessor();
        processor.setPrintAction(() -> processor.getListener().failed((Throwable)new RuntimeException("Printer error")));
        ReminderListBatchProcessor batchProcessor = new ReminderListBatchProcessor((ReminderItemSource)this.source, (ReminderListProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkStatus("ERROR", "Printer error", this.itemA1, this.itemA2, this.itemB1, this.itemC1);
        this.checkReminder(this.reminderA1, 0, this.due);
        this.checkReminder(this.reminderA2, 0, this.due);
        this.checkReminder(this.reminderB1, 0, this.due);
        this.checkReminder(this.reminderC1, 0, this.due);
        Assert.assertEquals((long)0L, (long)statistics.getCount());
        Assert.assertEquals((long)4L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)0L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)0L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)0L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testPrintCancellation() {
        TestReminderListProcessor processor = this.createProcessor();
        processor.setPrintAction(() -> processor.getListener().cancelled());
        ReminderListBatchProcessor batchProcessor = new ReminderListBatchProcessor((ReminderItemSource)this.source, (ReminderListProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkStatus("PENDING", null, this.itemA1, this.itemA2, this.itemB1, this.itemC1);
        this.checkReminder(this.reminderA1, 0, this.due);
        this.checkReminder(this.reminderA2, 0, this.due);
        this.checkReminder(this.reminderB1, 0, this.due);
        this.checkReminder(this.reminderC1, 0, this.due);
        Assert.assertEquals((long)0L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)0L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)0L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)0L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testChangeReminderBeforeUpdate() {
        TestReminderListProcessor processor = this.createProcessor();
        processor.setBeforeUpdateAction(() -> {
            this.reminderA1.setDescription("some description, not normally editable, but will force object to be saved");
            this.save((IMObject)this.reminderA1);
        });
        ReminderListBatchProcessor batchProcessor = new ReminderListBatchProcessor((ReminderItemSource)this.source, (ReminderListProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkStatus("ERROR", "Reminder was sent, but couldn't be updated. This may lead to a duplicate reminder. Failure reason: Reminder has been changed by another user", this.itemA1);
        this.checkCompleted(this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, 0, this.due);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<Act> printed = processor.getPrinted();
        Assert.assertEquals((long)4L, (long)printed.size());
        Assert.assertEquals((Object)this.reminderC1, (Object)printed.get(0));
        Assert.assertEquals((Object)this.reminderA1, (Object)printed.get(1));
        Assert.assertEquals((Object)this.reminderA2, (Object)printed.get(2));
        Assert.assertEquals((Object)this.reminderB1, (Object)printed.get(3));
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testChangeItemBeforeUpdate() {
        TestReminderListProcessor processor = this.createProcessor();
        processor.setBeforeUpdateAction(() -> {
            this.itemA1.setDescription("some description, not normally editable, but will force object to be saved");
            this.save((IMObject)this.itemA1);
        });
        ReminderListBatchProcessor batchProcessor = new ReminderListBatchProcessor((ReminderItemSource)this.source, (ReminderListProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        this.checkStatus("ERROR", "Reminder was sent, but couldn't be updated. This may lead to a duplicate reminder. Failure reason: Patient List Reminder has been changed by another user", this.itemA1);
        this.checkCompleted(this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, 0, this.due);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<Act> printed = processor.getPrinted();
        Assert.assertEquals((long)4L, (long)printed.size());
        Assert.assertEquals((Object)this.reminderC1, (Object)printed.get(0));
        Assert.assertEquals((Object)this.reminderA1, (Object)printed.get(1));
        Assert.assertEquals((Object)this.reminderA2, (Object)printed.get(2));
        Assert.assertEquals((Object)this.reminderB1, (Object)printed.get(3));
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testDeleteReminderBeforeUpdate() {
        TestReminderListProcessor processor = this.createProcessor();
        processor.setBeforeUpdateAction(() -> this.remove((IMObject)this.reminderA1));
        ReminderListBatchProcessor batchProcessor = new ReminderListBatchProcessor((ReminderItemSource)this.source, (ReminderListProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        Assert.assertNull((Object)this.get((IMObject)this.reminderA1));
        Assert.assertNull((Object)this.get((IMObject)this.itemA1));
        this.checkCompleted(this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<Act> printed = processor.getPrinted();
        Assert.assertEquals((long)4L, (long)printed.size());
        Assert.assertEquals((Object)this.reminderC1, (Object)printed.get(0));
        Assert.assertEquals((Object)this.reminderA1, (Object)printed.get(1));
        Assert.assertEquals((Object)this.reminderA2, (Object)printed.get(2));
        Assert.assertEquals((Object)this.reminderB1, (Object)printed.get(3));
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    @Test
    public void testDeleteItemBeforeUpdate() {
        TestReminderListProcessor processor = this.createProcessor();
        processor.setBeforeUpdateAction(() -> this.remove((IMObject)this.itemA1));
        ReminderListBatchProcessor batchProcessor = new ReminderListBatchProcessor((ReminderItemSource)this.source, (ReminderListProcessor)processor);
        Statistics statistics = new Statistics();
        batchProcessor.setStatistics(statistics);
        batchProcessor.process();
        Assert.assertNull((Object)this.get((IMObject)this.itemA1));
        this.checkCompleted(this.itemA2, this.itemB1, this.itemC1);
        Date oneWeek = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.WEEKS);
        Date oneMonth = DateRules.getDate((Date)this.due, (int)1, (DateUnits)DateUnits.MONTHS);
        this.checkReminder(this.reminderA1, 0, this.due);
        this.checkReminder(this.reminderA2, oneMonth);
        this.checkReminder(this.reminderB1, oneWeek);
        this.checkReminder(this.reminderC1, oneMonth);
        List<Act> printed = processor.getPrinted();
        Assert.assertEquals((long)4L, (long)printed.size());
        Assert.assertEquals((Object)this.reminderC1, (Object)printed.get(0));
        Assert.assertEquals((Object)this.reminderA1, (Object)printed.get(1));
        Assert.assertEquals((Object)this.reminderA2, (Object)printed.get(2));
        Assert.assertEquals((Object)this.reminderB1, (Object)printed.get(3));
        Assert.assertEquals((long)4L, (long)statistics.getCount());
        Assert.assertEquals((long)0L, (long)statistics.getErrors());
        Assert.assertEquals((long)0L, (long)statistics.getCancelled());
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType1, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)2L, (long)statistics.getCount(this.reminderType2, new String[]{"act.patientReminderItemList"}));
        Assert.assertEquals((long)4L, (long)this.communicationLogger.getLogs().size());
    }

    private TestReminderListProcessor createProcessor() {
        return new TestReminderListProcessor(this.reminderTypes, this.reminderRules, this.patientRules, this.location, this.practice, (ArchetypeService)this.getArchetypeService(), this.config, this.communicationLogger, this.actionFactory);
    }

    private static class TestReminderListProcessor
    extends ReminderListProcessor {
        private final List<Act> printed = new ArrayList<Act>();
        private Runnable printAction;
        private Runnable beforeUpdate;

        public TestReminderListProcessor(ReminderTypes reminderTypes, ReminderRules reminderRules, PatientRules patientRules, Party location, Party practice, ArchetypeService service, ReminderConfiguration config, CommunicationLogger communicationLogger, ActionFactory actionFactory) {
            super(reminderTypes, reminderRules, patientRules, location, practice, service, config, (IMPrinterFactory)Mockito.mock(IMPrinterFactory.class), communicationLogger, actionFactory, new HelpContext("foo", null));
        }

        public void setPrintAction(Runnable action) {
            this.printAction = action;
        }

        public void setBeforeUpdateAction(Runnable action) {
            this.beforeUpdate = action;
        }

        public List<Act> getPrinted() {
            return this.printed;
        }

        protected void print(List<Act> reminders) {
            if (this.printAction != null) {
                this.printAction.run();
            } else {
                this.printed.addAll(reminders);
                if (this.beforeUpdate != null) {
                    this.beforeUpdate.run();
                }
                this.onPrinted();
            }
        }

        protected void onPrinted() {
            this.getListener().printed(null);
        }
    }
}

