/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.payment;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.reporting.payment.AbstractPaymentsQuery;
import org.openvpms.web.workspace.reporting.payment.WorkInProgressPaymentsQuery;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPaymentsQueryTest
extends AbstractAppTest {
    private final boolean selectsPosted;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Entity till;
    private Party customer;

    protected AbstractPaymentsQueryTest(boolean selectsPosted) {
        this.selectsPosted = selectsPosted;
    }

    @Before
    public void setUp() {
        super.setUp();
        this.till = this.practiceFactory.createTill();
        this.customer = this.customerFactory.createCustomer();
    }

    @Test
    public void testEmptyQuery() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2, location3}).build();
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1}).build();
        context.setUser(user);
        context.setPractice(practice);
        AbstractPaymentsQuery query = this.createQuery((Context)context);
        query.setLocation(location1);
        QueryTestHelper.checkEmpty((Query)query);
        this.createPayment(location2, "IN_PROGRESS");
        this.createRefund(location2, "POSTED");
        this.createPayment(location3, "POSTED");
        QueryTestHelper.checkEmpty((Query)query);
    }

    @Test
    public void testQueryByLocation() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2, location3}).build();
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1, location2}).build();
        context.setUser(user);
        context.setPractice(practice);
        AbstractPaymentsQuery query = this.createQuery((Context)context);
        query.setLocation(null);
        FinancialAct payment1 = this.createPayment(null, "IN_PROGRESS");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{payment1});
        this.checkNoLocation(query, WorkInProgressPaymentsQuery.ARCHETYPES);
        FinancialAct payment2 = this.createPayment(location1, "IN_PROGRESS");
        FinancialAct refund = this.createRefund(location2, "IN_PROGRESS");
        FinancialAct payment3 = this.createPayment(location3, "IN_PROGRESS");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{payment1, payment2, refund});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{payment3});
        query.setLocation(location1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{payment2});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{payment1, refund, payment3});
    }

    @Test
    public void testQueryByLocationForUserWithNoLocations() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        User user = this.userFactory.createUser();
        Party practice = (Party)this.practiceFactory.newPractice().locations(new Party[]{location1, location2}).build();
        context.setUser(user);
        context.setPractice(practice);
        AbstractPaymentsQuery query = this.createQuery((Context)context);
        query.setLocation(null);
        this.checkNoLocation(query, WorkInProgressPaymentsQuery.ARCHETYPES);
        FinancialAct payment1 = this.createPayment(location1, "IN_PROGRESS");
        FinancialAct refund = this.createRefund(location2, "IN_PROGRESS");
        FinancialAct payment2 = this.createPayment(location3, "IN_PROGRESS");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{payment1, refund});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{payment2});
        query.setLocation(location1);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{payment1});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{refund, payment2});
    }

    @Test
    public void testQueryByStatus() {
        LocalContext context = new LocalContext();
        Party location1 = this.practiceFactory.createLocation();
        User user = (User)this.userFactory.newUser().addLocations(new Party[]{location1}).build();
        context.setUser(user);
        AbstractPaymentsQuery query = this.createQuery((Context)context);
        FinancialAct inProgress = this.createPayment(location1, "IN_PROGRESS");
        FinancialAct onHold = this.createPayment(location1, "ON_HOLD");
        FinancialAct posted = this.createPayment(location1, "POSTED");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{inProgress, onHold});
        if (this.selectsPosted) {
            QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{posted});
        } else {
            QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{posted});
        }
        query.setStatus("IN_PROGRESS");
        QueryTestHelper.checkExists((Query)query, (IMObject[])new FinancialAct[]{inProgress});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new FinancialAct[]{onHold, posted});
    }

    protected abstract AbstractPaymentsQuery createQuery(Context var1);

    private void checkNoLocation(AbstractPaymentsQuery query, String ... shortNames) {
        ResultSet set = query.query();
        ResultSetIterator iterator = new ResultSetIterator(set);
        while (iterator.hasNext()) {
            FinancialAct act = (FinancialAct)iterator.next();
            IMObjectBean bean = this.getBean((IMObject)act);
            Assert.assertTrue((boolean)bean.isA(shortNames));
            Assert.assertNull((Object)bean.getTargetRef("location"));
        }
    }

    private FinancialAct createPayment(Party location, String status) {
        return (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().till(this.till)).customer(this.customer)).location(location)).status(status)).cash(100).build();
    }

    private FinancialAct createRefund(Party location, String status) {
        return (FinancialAct)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().till(this.till)).customer(this.customer)).location(location)).status(status)).cash(100).build();
    }
}

