/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.problem;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.workspace.patient.problem.ProblemFilter;
import org.openvpms.web.workspace.patient.problem.ProblemHierarchyIterator;

public class ProblemHierarchyIteratorTestCase
extends ArchetypeServiceTest {
    private static final String[] SHORT_NAMES = new String[]{"act.patientWeight", "act.patientClinicalNote", "act.patientClinicalAddendum"};

    @Test
    public void testIterator() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Act note1 = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:04:00"), (Party)patient, (User)clinician);
        Act note2 = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2014-05-09 10:10:00"), (Party)patient, (User)clinician);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2014-05-09 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note1, note2});
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2014-05-09 09:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{problem, note1, note2});
        List<Act> acts = Collections.singletonList(problem);
        this.check(acts, SHORT_NAMES, true, problem, event, note1, note2);
        this.check(acts, SHORT_NAMES, false, problem, event, note2, note1);
    }

    @Test
    public void testAddendumLinkedToProblem() {
        Party patient = TestHelper.createPatient();
        User clinician = TestHelper.createClinician();
        Act note = PatientTestHelper.createNote((Date)TestHelper.getDatetime((String)"2016-03-20 10:00:05"), (Party)patient, (User)clinician);
        Act addendum1 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 11:00:00"), (Party)patient, (User)clinician);
        Act addendum2 = PatientTestHelper.createAddendum((Date)TestHelper.getDatetime((String)"2016-03-27 12:00:00"), (Party)patient, (User)clinician);
        PatientTestHelper.addAddendum((Act)note, (Act)addendum1);
        PatientTestHelper.addAddendum((Act)note, (Act)addendum2);
        Act problem = PatientTestHelper.createProblem((Date)TestHelper.getDatetime((String)"2016-03-20 10:05:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note, addendum1, addendum2});
        Act event = PatientTestHelper.createEvent((Date)TestHelper.getDatetime((String)"2016-03-20 10:00:00"), (Party)patient, (User)clinician, (Act[])new Act[]{note, addendum1, addendum2, problem});
        List<Act> acts = Collections.singletonList(problem);
        this.check(acts, SHORT_NAMES, true, problem, event, note, addendum1, addendum2);
        this.check(acts, SHORT_NAMES, false, problem, event, note, addendum1, addendum2);
    }

    private void check(List<Act> problems, String[] shortNames, boolean sortAscending, Act ... expected) {
        int index = 0;
        ProblemFilter filter = new ProblemFilter(shortNames, null, sortAscending, (ArchetypeService)this.getArchetypeService());
        for (Act act : new ProblemHierarchyIterator(problems, filter)) {
            Assert.assertEquals((Object)expected[index++], (Object)act);
        }
        Assert.assertEquals((long)expected.length, (long)index);
    }
}

