/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientMedicationBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.patient.mr.PatientMedicationActEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientMedicationActEditorTestCase
extends AbstractIMObjectEditorTest<PatientMedicationActEditor> {
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestProductFactory productFactory;

    public PatientMedicationActEditorTestCase() {
        super(PatientMedicationActEditor.class, "act.patientMedication");
    }

    @Test
    public void testBatchExpiry() {
        LocalContext context = new LocalContext();
        Date today = DateRules.getToday();
        Date month1 = DateRules.getDate((Date)today, (int)1, (DateUnits)DateUnits.MONTHS);
        Date month2 = DateRules.getDate((Date)today, (int)2, (DateUnits)DateUnits.MONTHS);
        Party patient = this.patientFactory.createPatient();
        Product product = this.productFactory.createMedication();
        Entity batch1 = this.productFactory.createBatch(product, "123456788", month1);
        Entity batch2 = this.productFactory.createBatch(product, "123456789", month2);
        Act act = this.patientFactory.createMedication(patient, product);
        DefaultLayoutContext layoutContext1 = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        PatientMedicationActEditor editor1 = new PatientMedicationActEditor(act, null, (LayoutContext)layoutContext1);
        editor1.getComponent();
        Assert.assertNull((Object)editor1.getBatch());
        editor1.setBatch(batch1);
        Assert.assertEquals((Object)batch1, (Object)editor1.getBatch());
        Assert.assertEquals((Object)month1, (Object)editor1.getExpiryDate());
        editor1.setExpiryDate(today);
        Assert.assertEquals((Object)today, (Object)editor1.getExpiryDate());
        editor1.setExpiryDate(DateRules.getNextDate((Date)month1));
        Assert.assertEquals((Object)month1, (Object)editor1.getExpiryDate());
        editor1.setExpiryDate(null);
        Assert.assertEquals((Object)month1, (Object)editor1.getExpiryDate());
        editor1.setBatch(batch2);
        Assert.assertEquals((Object)month2, (Object)editor1.getExpiryDate());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        this.productFactory.updateBatch(batch2).expiryDate(month1).build();
        DefaultLayoutContext layoutContext2 = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        PatientMedicationActEditor editor2 = new PatientMedicationActEditor(act, null, (LayoutContext)layoutContext2);
        editor2.getComponent();
        EditorTestHelper.assertInvalid((Modifiable)editor2, (String)("The Expiry Date must be set to " + DateFormatter.formatDate((Date)month1, (boolean)false) + " or earlier."));
    }

    @Test
    public void testBatchExpiringToday() {
        LocalContext context = new LocalContext();
        Date today = DateRules.getToday();
        Party patient = this.patientFactory.createPatient();
        Product product = this.productFactory.createMedication();
        Entity batch1 = this.productFactory.createBatch(product, "123456788", today);
        Act act = (Act)((TestPatientMedicationBuilder)((TestPatientMedicationBuilder)this.patientFactory.newMedication().startTime(DateRules.getDate((Date)today, (int)5, (DateUnits)DateUnits.HOURS))).patient(patient)).product(product).build();
        DefaultLayoutContext layoutContext1 = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        PatientMedicationActEditor editor = new PatientMedicationActEditor(act, null, (LayoutContext)layoutContext1);
        editor.getComponent();
        Assert.assertNull((Object)editor.getBatch());
        Assert.assertNull((Object)editor.getEndTime());
        Assert.assertNull((Object)editor.getExpiryDate());
        editor.setBatch(batch1);
        Assert.assertEquals((Object)batch1, (Object)editor.getBatch());
        Assert.assertEquals((Object)today, (Object)editor.getEndTime());
        Assert.assertEquals((Object)today, (Object)editor.getExpiryDate());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
    }

    @Test
    public void testCantChangeProductForInvoicedMedication() {
        Party patient = this.patientFactory.createPatient();
        Product product = this.productFactory.createMedication();
        Act act = (Act)this.create("act.patientMedication", Act.class);
        new TestInvoiceItemBuilder(null, (ArchetypeService)this.getArchetypeService()).medication(act).build(false);
        LocalContext context = new LocalContext();
        context.setPatient(patient);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        PatientMedicationActEditor editor = new PatientMedicationActEditor(act, null, (LayoutContext)layoutContext);
        Assert.assertEquals((Object)patient, (Object)editor.getPatient());
        Assert.assertNull((Object)editor.getProduct());
        editor.getComponent();
        Assert.assertNull((Object)editor.getProductEditor());
        editor.setProduct(product);
        Assert.assertEquals((Object)product, (Object)editor.getProduct());
    }

    @Test
    public void testCanChangeProductForStandaloneMedication() {
        Party patient = this.patientFactory.createPatient();
        Product product = this.productFactory.createMedication();
        LocalContext context = new LocalContext();
        context.setPatient(patient);
        Act act = (Act)this.create("act.patientMedication", Act.class);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        PatientMedicationActEditor editor = new PatientMedicationActEditor(act, null, (LayoutContext)layoutContext);
        Assert.assertEquals((Object)patient, (Object)editor.getPatient());
        Assert.assertNull((Object)editor.getProduct());
        editor.getComponent();
        Assert.assertNotNull((Object)editor.getProductEditor());
        editor.setProduct(product);
        Assert.assertEquals((Object)product, (Object)editor.getProduct());
    }
}

