/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.mr;

import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.DocumentActEditor;
import org.openvpms.web.component.im.doc.TemplatedVersionedDocumentActEditorTest;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.patient.mr.PatientLetterEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientLetterEditorTestCase
extends TemplatedVersionedDocumentActEditorTest<PatientLetterEditor> {
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;

    public PatientLetterEditorTestCase() {
        super(PatientLetterEditor.class, "act.patientDocumentLetter");
    }

    @Test
    public void testDocRegeneration() {
        DocumentAct act = this.createAct();
        Entity template = this.createDocumentTemplate(act.getArchetype());
        PatientLetterEditor editor = this.createEditor(act);
        editor.getComponent();
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        editor.setTemplate(template);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.NEEDS_UPDATE, (Object)editor.getDocumentStatus());
        editor.generateDocument(success -> {
            Assert.assertNotNull((Object)success);
            Assert.assertTrue((boolean)success);
        });
        this.processQueuedTasks(10, () -> act.getDocument() != null);
        Reference docRef1 = act.getDocument();
        Assert.assertNotNull((Object)docRef1);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Assert.assertTrue((boolean)this.save((DocumentActEditor)editor));
        Document doc1 = (Document)this.get(docRef1);
        Assert.assertNotNull((Object)doc1);
        Assert.assertEquals((Object)"application/pdf", (Object)doc1.getMimeType());
        Assert.assertEquals((Object)"blank.pdf", (Object)doc1.getName());
        editor.setClinician(this.userFactory.createClinician());
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        editor.generateDocument(success -> {
            Assert.assertNotNull((Object)success);
            Assert.assertTrue((boolean)success);
        });
        this.processQueuedTasks(10, () -> !Objects.equals(docRef1, act.getDocument()));
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Assert.assertTrue((boolean)this.save((DocumentActEditor)editor));
        Reference docRef2 = act.getDocument();
        Assert.assertNotNull((Object)docRef2);
        Assert.assertNotEquals((Object)docRef1, (Object)docRef2);
        Document doc2 = (Document)this.get(docRef2);
        Assert.assertNotNull((Object)doc2);
        List versions1 = this.getVersions(act);
        Assert.assertEquals((long)1L, (long)versions1.size());
        this.checkVersion(versions1, 0, docRef1);
        editor.setProduct(this.productFactory.createService());
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        editor.generateDocument(success -> {
            Assert.assertNotNull((Object)success);
            Assert.assertTrue((boolean)success);
        });
        this.processQueuedTasks(10, () -> !Objects.equals(docRef2, act.getDocument()));
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Assert.assertTrue((boolean)this.save((DocumentActEditor)editor));
        Reference docRef3 = act.getDocument();
        Assert.assertNotNull((Object)docRef3);
        Assert.assertNotEquals((Object)docRef2, (Object)docRef3);
        Document doc3 = (Document)this.get(docRef3);
        Assert.assertNotNull((Object)doc3);
        List versions2 = this.getVersions(act);
        Assert.assertEquals((long)2L, (long)versions2.size());
        this.checkVersion(versions2, 0, docRef1);
        this.checkVersion(versions2, 1, docRef2);
    }

    protected PatientLetterEditor createEditor(DocumentAct act) {
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        Context context = layout.getContext();
        context.setPatient(this.patientFactory.createPatient());
        context.setUser(this.userFactory.createUser());
        return new PatientLetterEditor(act, null, (LayoutContext)layout);
    }

    protected Document createDocument() {
        return this.createImage();
    }
}

