/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.insurance.TestInsurerBuilder;
import org.openvpms.archetype.test.builder.party.TestContactFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.supplier.TestVetBuilder;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.AbstractMailContextTest;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.patient.insurance.claim.InsurerMailContext;
import org.springframework.beans.factory.annotation.Autowired;

public class InsurerMailContextTestCase
extends AbstractMailContextTest {
    @Autowired
    private TestContactFactory contactFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;

    @Test
    public void testContext() {
        LocalContext context = new LocalContext();
        InsurerMailContext mailContext = new InsurerMailContext((Context)context, new HelpContext("foo", null));
        Assert.assertNull((Object)mailContext.getInsurer());
        Assert.assertNull((Object)mailContext.getCustomer());
        Assert.assertNull((Object)mailContext.getPatient());
        this.checkAddresses(mailContext.getToAddresses(), null, new Contact[0]);
        Contact insurerContact1 = this.contactFactory.createEmail("info@insurer1.com", new String[0]);
        Party insurer1 = (Party)((TestInsurerBuilder)this.insuranceFactory.newInsurer().addContacts(new Contact[]{insurerContact1})).build();
        Contact insurerContact2 = this.contactFactory.createEmail("info@insurer2.com", new String[0]);
        Party insurer2 = (Party)((TestInsurerBuilder)this.insuranceFactory.newInsurer().addContacts(new Contact[]{insurerContact2})).build();
        Contact customerContact = this.contactFactory.createEmail("customer1@gmail.com", new String[0]);
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContacts(new Contact[]{customerContact})).build();
        Contact vetContact = this.contactFactory.createEmail("vet@vetsrus.com", new String[0]);
        Party vet = (Party)((TestVetBuilder)this.supplierFactory.newVet().addContacts(new Contact[]{vetContact})).build();
        Party patient = (Party)this.patientFactory.newPatient().owner(customer).addReferredTo(vet).build();
        context.setSupplier(insurer1);
        context.setCustomer(customer);
        context.setPatient(patient);
        this.checkAddresses(mailContext.getToAddresses(), insurerContact1, insurerContact1, customerContact, vetContact);
        context.setSupplier(insurer2);
        this.checkAddresses(mailContext.getToAddresses(), insurerContact2, insurerContact2, customerContact, vetContact);
    }

    @Test
    public void testUpdateInsurer() {
        LocalContext context = new LocalContext();
        InsurerMailContext mailContext = new InsurerMailContext((Context)context, new HelpContext("foo", null));
        Contact contactA = this.contactFactory.createEmail("info@insurer1.com", new String[0]);
        Contact contactB = this.contactFactory.createEmail("info@insurer2.com", true, new String[0]);
        Party insurer = (Party)((TestInsurerBuilder)this.insuranceFactory.newInsurer().addContacts(new Contact[]{contactA})).build();
        context.setSupplier(insurer);
        this.checkAddresses(mailContext.getToAddresses(), contactA, contactA);
        ((TestInsurerBuilder)this.insuranceFactory.updateInsurer(insurer).addContacts(new Contact[]{contactB})).build();
        this.checkAddresses(mailContext.getToAddresses(), contactB, contactA, contactB);
    }
}

