/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.insurance.TestClaimBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.patient.TestAddendumBuilder;
import org.openvpms.archetype.test.builder.patient.TestAttachmentBuilder;
import org.openvpms.archetype.test.builder.patient.TestNoteBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.patient.insurance.claim.ChargeCollectionEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimEditor;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimItemEditor;
import org.openvpms.web.workspace.patient.insurance.claim.TestClaimEditor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ClaimEditorTestCase
extends AbstractAppTest {
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party customer;
    private Party patient;
    private User clinician;
    private Party practice;
    private Party location;
    private User user;
    private Act policyAct;

    @Before
    public void setUp() {
        super.setUp();
        this.practice = this.practiceFactory.getPractice();
        this.customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().name("MS", "J", "Bloggs").addAddress("12 Broadwater Avenue", "CAPE_WOOLAMAI", "VIC", "3925", new String[0])).addHomePhone("9123456").addWorkPhone("98765432").addMobilePhone("04987654321")).addEmail("foo@test.com", new String[0])).build();
        this.location = (Party)((TestLocationBuilder)((TestLocationBuilder)this.practiceFactory.newLocation().addPhone("5123456", new String[0])).addEmail("vetsrus@test.com", new String[0])).build();
        this.clinician = this.userFactory.createClinician();
        this.user = this.userFactory.createUser("Z", "Smith");
        Date dateOfBirth = DateRules.getDate((Date)DateRules.getToday(), (int)-1, (DateUnits)DateUnits.YEARS);
        this.patient = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("Fido")).species("CANINE").breed("PUG").male().dateOfBirth(dateOfBirth).addMicrochip("123454321").colour("BLACK").owner(this.customer).build();
        Act note1 = (Act)((TestNoteBuilder)((TestNoteBuilder)((TestNoteBuilder)((TestNoteBuilder)this.patientFactory.newNote().startTime("2015-05-01")).patient(this.patient)).clinician(this.clinician)).note("Note 1")).build();
        Act note2 = (Act)((TestNoteBuilder)((TestNoteBuilder)((TestNoteBuilder)((TestNoteBuilder)this.patientFactory.newNote().startTime("2015-05-02")).patient(this.patient)).clinician(this.clinician)).note("Note 2")).build();
        ((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().startTime("2015-05-01")).patient(this.patient)).addItems(new Act[]{note1, note2}).build();
        DocumentAct note3 = (DocumentAct)((TestNoteBuilder)((TestNoteBuilder)((TestNoteBuilder)((TestNoteBuilder)this.patientFactory.newNote().startTime("2015-07-01")).patient(this.patient)).clinician(this.clinician)).note("Note 3")).build();
        DocumentAct addendum1 = (DocumentAct)((TestAddendumBuilder)((TestAddendumBuilder)((TestAddendumBuilder)((TestAddendumBuilder)this.patientFactory.newAddendum().startTime("2015-07-03")).patient(this.patient)).clinician(this.clinician)).note("Note 3 addendum 1")).build();
        DocumentAct addendum2 = (DocumentAct)((TestAddendumBuilder)((TestAddendumBuilder)((TestAddendumBuilder)((TestAddendumBuilder)this.patientFactory.newAddendum().startTime("2015-07-04")).patient(this.patient)).clinician(this.clinician)).note("Note 3 addendum 2")).build();
        this.patientFactory.updateNote(note3).addAddenda(new DocumentAct[]{addendum1, addendum2}).build();
        ((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().startTime("2015-07-01")).patient(this.patient)).addItems(new Act[]{note3}).build();
        Party insurer = this.insuranceFactory.createInsurer();
        this.policyAct = this.insuranceFactory.createPolicy(this.customer, this.patient, insurer, "POL123456");
    }

    @Test
    public void testDelete() {
        Product product1 = this.productFactory.createService();
        Date itemDate1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        BigDecimal discount1 = new BigDecimal("0.10");
        BigDecimal tax1 = new BigDecimal("0.08");
        FinancialAct invoiceItem1 = this.createInvoiceItem(itemDate1, product1, BigDecimal.ONE, BigDecimal.ONE, discount1, tax1);
        FinancialAct invoice1 = this.createInvoice(TestHelper.getDate((String)"2017-09-27"), invoiceItem1);
        Document content1 = this.documentFactory.createPDF();
        DocumentAct documentAct1 = (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().startTime(itemDate1)).patient(this.patient)).document(content1)).build();
        Document content2 = this.documentFactory.createDOC();
        DocumentAct documentAct2 = (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().startTime(itemDate1)).patient(this.patient)).document(content2)).build();
        TestClaimBuilder builder = this.insuranceFactory.newClaim();
        final FinancialAct claimAct = (FinancialAct)builder.policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user).item().diagnosis("VENOM_328").treatmentDates(itemDate1, itemDate1).invoiceItems(new FinancialAct[]{invoiceItem1}).add().attachments(new Act[]{documentAct1, documentAct2}).build();
        FinancialAct item1Act = (FinancialAct)builder.getItems().get(0);
        List attachments = builder.getAttachments();
        Assert.assertEquals((long)2L, (long)attachments.size());
        DocumentAct attachment1 = (DocumentAct)attachments.get(0);
        Document attachmentContent1 = this.documentFactory.createPDF();
        attachment1.setDocument(attachmentContent1.getObjectReference());
        DocumentAct attachment2 = (DocumentAct)attachments.get(1);
        Document attachmentContent2 = this.documentFactory.createDOC();
        attachment2.setDocument(attachmentContent2.getObjectReference());
        this.save((IMObject[])new DocumentAct[]{attachment1, attachment2});
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                ClaimEditor editor = ClaimEditorTestCase.this.createEditor(claimAct);
                editor.delete();
            }
        });
        Assert.assertNull((Object)this.get((IMObject)claimAct));
        Assert.assertNull((Object)this.get((IMObject)item1Act));
        Assert.assertNull((Object)this.get((IMObject)attachment1));
        Assert.assertNull((Object)this.get((IMObject)attachmentContent1));
        Assert.assertNull((Object)this.get((IMObject)claimAct));
        Assert.assertNull((Object)this.get((IMObject)attachment2));
        Assert.assertNull((Object)this.get((IMObject)attachmentContent2));
        Assert.assertNotNull((Object)this.get((IMObject)documentAct1));
        Assert.assertNotNull((Object)this.get((IMObject)content1));
        Assert.assertNotNull((Object)this.get((IMObject)documentAct2));
        Assert.assertNotNull((Object)this.get((IMObject)content2));
        Assert.assertNotNull((Object)this.get((IMObject)this.policyAct));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem1));
        Assert.assertNotNull((Object)this.get((IMObject)invoice1));
    }

    @Test
    public void testDeleteClaimItem() {
        Date date1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        FinancialAct invoiceItem1 = this.createInvoiceItem(date1);
        FinancialAct invoice1 = this.createPaidInvoice(date1, invoiceItem1);
        Date date2 = TestHelper.getDatetime((String)"2017-10-27 15:00:00");
        FinancialAct invoiceItem2 = this.createInvoiceItem(date2);
        FinancialAct invoice2 = this.createPaidInvoice(date2, invoiceItem2);
        FinancialAct item1Act = (FinancialAct)this.insuranceFactory.newClaimItem().diagnosis("VENOM_328").treatmentDates(date1, date1).invoiceItems(new FinancialAct[]{invoiceItem1}).build();
        FinancialAct item2Act = (FinancialAct)this.insuranceFactory.newClaimItem().diagnosis("VENOM_328").treatmentDates(date2, date2).invoiceItems(new FinancialAct[]{invoiceItem2}).build();
        FinancialAct claimAct = (FinancialAct)this.insuranceFactory.newClaim().policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user).addItem(item1Act).addItem(item2Act).build();
        ClaimEditor editor = this.createEditor(claimAct);
        this.checkClaim(claimAct, new BigDecimal("1.64"), BigDecimal.valueOf(18L));
        editor.getItems().remove((IMObject)item2Act);
        this.checkClaim(claimAct, new BigDecimal("0.82"), BigDecimal.valueOf(9L));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)this.get((IMObject)item2Act));
        Assert.assertNotNull((Object)this.get((IMObject)invoice1));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem1));
        Assert.assertNotNull((Object)this.get((IMObject)invoice2));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem2));
        Assert.assertNotNull((Object)item1Act);
    }

    @Test
    public void testDeleteAttachment() {
        Date itemDate1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        FinancialAct invoiceItem1 = this.createInvoiceItem(itemDate1);
        this.createPaidInvoice(TestHelper.getDate((String)"2017-09-27"), invoiceItem1);
        Document content = this.documentFactory.createPDF();
        DocumentAct documentAct = (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().startTime(itemDate1)).patient(this.patient)).document(content)).build();
        FinancialAct item1Act = (FinancialAct)this.insuranceFactory.newClaimItem().diagnosis("VENOM_328").treatmentDates(itemDate1, itemDate1).invoiceItems(new FinancialAct[]{invoiceItem1}).build();
        TestClaimBuilder builder = this.insuranceFactory.newClaim();
        FinancialAct claimAct = (FinancialAct)builder.policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user).addItem(item1Act).attachment((Act)documentAct).build();
        List attachments = builder.getAttachments();
        Assert.assertEquals((long)1L, (long)attachments.size());
        DocumentAct attachment = (DocumentAct)attachments.get(0);
        Document copy = this.documentFactory.createPDF();
        attachment.setDocument(copy.getObjectReference());
        this.save((IMObject)attachment);
        ClaimEditor editor = this.createEditor(claimAct);
        editor.getAttachments().remove((IMObject)attachment);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)this.get((IMObject)attachment));
        Assert.assertNull((Object)this.get((IMObject)copy));
        Assert.assertNotNull((Object)this.get((IMObject)documentAct));
        Assert.assertNotNull((Object)this.get((IMObject)content));
    }

    @Test
    public void testDeleteInvoiceItem() {
        Date date1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        FinancialAct invoiceItem1 = this.createInvoiceItem(date1);
        FinancialAct invoiceItem2 = this.createInvoiceItem(date1);
        FinancialAct invoice1 = this.createPaidInvoice(date1, invoiceItem1, invoiceItem2);
        FinancialAct item1Act = (FinancialAct)this.insuranceFactory.newClaimItem().diagnosis("VENOM_328").treatmentDates(date1, date1).invoiceItems(new FinancialAct[]{invoiceItem1, invoiceItem2}).build();
        FinancialAct claimAct = (FinancialAct)this.insuranceFactory.newClaim().policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user).addItem(item1Act).build();
        ClaimEditor editor = this.createEditor(claimAct);
        this.checkClaim(claimAct, new BigDecimal("1.64"), BigDecimal.valueOf(18L));
        ClaimItemEditor itemEditor = (ClaimItemEditor)editor.getItems().getEditor((IMObject)item1Act);
        Assert.assertNotNull((Object)itemEditor);
        ChargeCollectionEditor chargeCollectionEditor = itemEditor.getChargeCollectionEditor();
        chargeCollectionEditor.getComponent();
        chargeCollectionEditor.remove((IMObject)invoiceItem1);
        this.checkClaim(claimAct, new BigDecimal("0.82"), BigDecimal.valueOf(9L));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNotNull((Object)this.get((IMObject)invoice1));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem1));
        Assert.assertNotNull((Object)this.get((IMObject)invoiceItem2));
    }

    @Test
    public void testClaimWithPolicyForDifferentCustomer() {
        Product product1 = this.productFactory.createMedication();
        Date itemDate1 = TestHelper.getDatetime((String)"2017-09-27 10:00:00");
        BigDecimal discount1 = new BigDecimal("0.10");
        BigDecimal tax1 = new BigDecimal("0.08");
        FinancialAct invoiceItem1 = this.createInvoiceItem(itemDate1, product1, BigDecimal.ONE, BigDecimal.ONE, discount1, tax1);
        this.createPaidInvoice(TestHelper.getDate((String)"2017-09-27"), invoiceItem1);
        FinancialAct item1Act = (FinancialAct)this.insuranceFactory.newClaimItem().diagnosis("VENOM_328").treatmentDates(itemDate1, itemDate1).invoiceItems(new FinancialAct[]{invoiceItem1}).build();
        FinancialAct claimAct = (FinancialAct)this.insuranceFactory.newClaim().policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user).addItem(item1Act).build();
        ClaimEditor editor1 = this.createEditor(claimAct);
        Assert.assertTrue((boolean)editor1.isValid());
        IMObjectBean bean = this.getBean((IMObject)this.policyAct);
        Party customer2 = this.customerFactory.createCustomer();
        bean.setTarget("customer", (IMObject)customer2);
        bean.save();
        ClaimEditor editor2 = this.createEditor(claimAct);
        EditorTestHelper.assertInvalid((Modifiable)editor2, (String)("Cannot make a claim with this policy.\n\nIt belongs to a different customer: " + customer2.getName() + "."));
    }

    @Test
    public void testCannotMakeGapClaimWhenInvoiceFullyPaid() {
        Date date1 = new Date();
        FinancialAct invoiceItem1 = this.createInvoiceItem(date1);
        FinancialAct invoiceItem2 = this.createInvoiceItem(date1);
        this.createPaidInvoice(date1, invoiceItem1, invoiceItem2);
        FinancialAct item1Act = (FinancialAct)this.insuranceFactory.newClaimItem().diagnosis("VENOM_328").treatmentDates(date1, date1).invoiceItems(new FinancialAct[]{invoiceItem1, invoiceItem2}).build();
        FinancialAct claimAct = (FinancialAct)this.insuranceFactory.newClaim().policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user).gapClaim(true).addItem(item1Act).build();
        ClaimEditor editor = this.createEditor(claimAct);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Cannot make a gap claim as all invoices in this claim have been fully paid.");
    }

    @Test
    public void testAddVisit() {
        Date date1 = new Date();
        FinancialAct invoiceItem1 = this.createInvoiceItem(date1);
        FinancialAct invoiceItem2 = this.createInvoiceItem(date1);
        this.createPaidInvoice(date1, invoiceItem1, invoiceItem2);
        Act visit = (Act)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().reason("CHECKUP")).startTime(new Date())).endTime(new Date())).patient(this.patient)).addChargeItems(new FinancialAct[]{invoiceItem1, invoiceItem2}).build();
        FinancialAct claimAct = (FinancialAct)this.insuranceFactory.newClaim().policy(this.policyAct).location(this.location).clinician(this.clinician).claimHandler(this.user).build(false);
        ClaimEditor editor = this.createEditor(claimAct);
        editor.getItems().addVisit(visit);
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkClaim(claimAct, new BigDecimal("1.64"), BigDecimal.valueOf(18L));
        FinancialAct item = (FinancialAct)this.getBean((IMObject)claimAct).getTarget("items", FinancialAct.class);
        List chargeItemsRefs = this.getBean((IMObject)item).getTargetRefs("items");
        Assert.assertEquals((long)2L, (long)chargeItemsRefs.size());
        Assert.assertTrue((boolean)chargeItemsRefs.contains(invoiceItem1.getObjectReference()));
        Assert.assertTrue((boolean)chargeItemsRefs.contains(invoiceItem2.getObjectReference()));
    }

    private ClaimEditor createEditor(FinancialAct claim) {
        LocalContext context = new LocalContext();
        context.setPatient(this.patient);
        context.setCustomer(this.customer);
        context.setPractice(this.practice);
        context.setLocation(this.location);
        context.setUser(this.user);
        DefaultLayoutContext layout = new DefaultLayoutContext(true, (Context)context, new HelpContext("foo", null));
        TestClaimEditor editor = new TestClaimEditor(claim, (LayoutContext)layout);
        editor.getComponent();
        return editor;
    }

    private void checkClaim(FinancialAct claim, BigDecimal tax, BigDecimal total) {
        this.checkEquals(tax, claim.getTaxAmount());
        this.checkEquals(total, claim.getTotal());
    }

    private FinancialAct createInvoiceItem(Date date) {
        BigDecimal discount = BigDecimal.ONE;
        BigDecimal tax = new BigDecimal("0.82");
        return this.createInvoiceItem(date, this.productFactory.createService(), BigDecimal.ONE, BigDecimal.TEN, discount, tax);
    }

    private FinancialAct createInvoiceItem(Date date, Product product, BigDecimal quantity, BigDecimal price, BigDecimal discount, BigDecimal tax) {
        return (FinancialAct)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)this.accountFactory.newInvoiceItem().startTime(date)).patient(this.patient)).clinician(this.clinician)).product(product)).quantity(quantity)).unitPrice(price)).discount(discount)).tax(tax)).build();
    }

    private FinancialAct createInvoice(Date date, FinancialAct ... items) {
        return (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().startTime(date)).customer(this.customer)).clinician(this.clinician)).status("POSTED")).add(items)).build();
    }

    private FinancialAct createPaidInvoice(Date date, FinancialAct ... items) {
        FinancialAct invoice = this.createInvoice(date, items);
        invoice.setAllocatedAmount(invoice.getTotal());
        this.save((IMObject)invoice);
        return invoice;
    }
}

