/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance;

import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.AbstractButton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.insurance.TestPolicyBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.OptionDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.patient.insurance.InsuranceCRUDWindow;
import org.openvpms.web.workspace.patient.insurance.claim.ClaimEditor;
import org.openvpms.web.workspace.patient.insurance.claim.TestGapInsuranceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.test.annotation.DirtiesContext;

@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class InsuranceCRUDWindowTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party customer;
    private Party patient;
    private Party insurer;
    private Act policy1;

    @Before
    public void setUp() {
        super.setUp();
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.insurer = this.insuranceFactory.createInsurer();
        this.policy1 = this.insuranceFactory.createPolicy(this.customer, this.patient, this.insurer, "1");
        Assert.assertNotNull((Object)this.applicationContext);
        SingletonBeanRegistry factory = (SingletonBeanRegistry)this.applicationContext.getAutowireCapableBeanFactory();
        if (!factory.containsSingleton("insuranceServices")) {
            TestGapInsuranceService service = new TestGapInsuranceService();
            InsuranceServices insuranceServices = (InsuranceServices)Mockito.mock(InsuranceServices.class);
            Mockito.when((Object)insuranceServices.getService((Party)Mockito.any())).thenReturn((Object)service);
            factory.registerSingleton("insuranceServices", (Object)insuranceServices);
        }
    }

    @Test
    public void testClaim() {
        InsuranceCRUDWindow window = this.createWindow(this.customer, this.patient);
        window.claim(null);
        this.checkClaimEditor();
    }

    @Test
    public void testClaimWithNoCustomer() {
        InsuranceCRUDWindow window = this.createWindow(null, this.patient);
        window.claim(null);
        EchoTestHelper.findMessageDialogAndFireButton(ErrorDialog.class, (String)"Error", (String)"Cannot make an insurance claim.\nThe patient has no owner.", (String)"ok");
        Assert.assertNull((Object)EchoTestHelper.findEditDialog());
    }

    @Test
    public void testClaimFromPolicy() {
        InsuranceCRUDWindow window = this.createWindow(this.customer, this.patient);
        window.claim(this.policy1);
        this.checkClaimEditor();
    }

    @Test
    public void testClaimFromExpiredPolicy() {
        this.policy1 = (Act)((TestPolicyBuilder)((TestPolicyBuilder)this.insuranceFactory.updatePolicy(this.policy1).startTime("2024-01-01")).endTime("2025-01-01")).build();
        InsuranceCRUDWindow window = this.createWindow(this.customer, this.patient);
        window.claim(this.policy1);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"Expired Policy", (String)"This policy has expired.\n\nDo you still wish to make a claim?", (String)"yes");
        this.checkClaimEditor();
    }

    @Test
    public void testClaimFromOldPolicy() {
        ((TestPolicyBuilder)((TestPolicyBuilder)this.insuranceFactory.updatePolicy(this.policy1).startTime("2024-01-01")).endTime("2025-01-01")).build();
        Act policy2 = this.insuranceFactory.createPolicy(this.customer, this.patient, this.insurer, "2");
        InsuranceCRUDWindow window = this.createWindow(this.customer, this.patient);
        window.claim(this.policy1);
        OptionDialog optionDialog = (OptionDialog)EchoTestHelper.findWindowPane(OptionDialog.class);
        Assert.assertNotNull((Object)optionDialog);
        RadioButton option = optionDialog.getOption(0);
        Assert.assertNotNull((Object)option);
        Assert.assertEquals((Object)(this.insurer.getName() + " - 2 (Latest)"), (Object)option.getText());
        EchoTestHelper.fireButton((AbstractButton)option);
        ClaimEditor editor = this.checkClaimEditor();
        Assert.assertEquals((Object)policy2, (Object)editor.getPolicy());
    }

    @Test
    public void testClaimFromPolicyWithOutstandingClaim() {
        this.createClaim(this.policy1, "SUBMITTED");
        InsuranceCRUDWindow window = this.createWindow(this.customer, this.patient);
        window.claim(this.policy1);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"New Insurance Claim", (String)"This policy already has an outstanding claim.\n\nDo you wish to create another claim?", (String)"yes");
        this.checkClaimEditor();
    }

    @Test
    public void testClaimFromPolicyWithDifferentCustomer() {
        InsuranceCRUDWindow window = this.createWindow(this.customerFactory.createCustomer(), this.patient);
        window.claim(this.policy1);
        EchoTestHelper.findMessageDialogAndFireButton(ErrorDialog.class, (String)"Error", (String)("Cannot make a claim with this policy.\n\nIt belongs to a different customer: " + this.customer.getName() + "."), (String)"ok");
        Assert.assertNull((Object)EchoTestHelper.findEditDialog());
    }

    @Test
    public void testClaimFromPolicyWithDifferentPatient() {
        InsuranceCRUDWindow window = this.createWindow(this.customer, this.patientFactory.createPatient());
        window.claim(this.policy1);
        EchoTestHelper.findMessageDialogAndFireButton(ErrorDialog.class, (String)"Error", (String)("Cannot make a claim with this policy.\n\nIt belongs to a different patient: " + this.patient.getName() + "."), (String)"ok");
        Assert.assertNull((Object)EchoTestHelper.findEditDialog());
    }

    @Test
    public void testClaimFromClaim() {
        Act claim = this.createClaim(this.policy1, "SETTLED");
        InsuranceCRUDWindow window = this.createWindow(this.customer, this.patient);
        window.claim(claim);
        this.checkClaimEditor();
    }

    @Test
    public void testClaimFromClaimWithOldPolicy() {
        Act policy1 = this.insuranceFactory.createPolicy(this.customer, this.patient, this.insurer, "1");
        ((TestPolicyBuilder)((TestPolicyBuilder)this.insuranceFactory.updatePolicy(policy1).startTime("2024-01-01")).endTime("2025-01-01")).build();
        this.insuranceFactory.createPolicy(this.customer, this.patient, this.insurer, "2");
        Act claim = this.createClaim(policy1, "SETTLED");
        InsuranceCRUDWindow window = this.createWindow(this.customer, this.patient);
        window.claim(claim);
        OptionDialog optionDialog = (OptionDialog)EchoTestHelper.findWindowPane(OptionDialog.class);
        Assert.assertNotNull((Object)optionDialog);
        RadioButton option = optionDialog.getOption(1);
        Assert.assertNotNull((Object)option);
        Assert.assertEquals((Object)(this.insurer.getName() + " - 1 - Expired"), (Object)option.getText());
        EchoTestHelper.fireButton((AbstractButton)option);
        ClaimEditor editor = this.checkClaimEditor();
        Assert.assertEquals((Object)policy1, (Object)editor.getPolicy());
    }

    @Test
    public void testClaimFromOutstandingClaim() {
        Act claim = this.createClaim(this.policy1, "ACCEPTED");
        InsuranceCRUDWindow window = this.createWindow(this.customer, this.patient);
        window.claim(claim);
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, (String)"New Insurance Claim", (String)"This policy already has an outstanding claim.\n\nDo you wish to create another claim?", (String)"yes");
        this.checkClaimEditor();
    }

    private Act createClaim(Act policy, String status) {
        User clinician = this.userFactory.createClinician();
        return (Act)this.insuranceFactory.newClaim().policy(policy).location(this.practiceFactory.createLocation()).clinician(clinician).claimHandler(clinician).item().add().status(status).build();
    }

    private ClaimEditor checkClaimEditor() {
        EditDialog dialog = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog);
        Assert.assertTrue((boolean)(dialog.getEditor() instanceof ClaimEditor));
        ClaimEditor editor = (ClaimEditor)dialog.getEditor();
        Assert.assertTrue((boolean)editor.getObject().isNew());
        return editor;
    }

    private InsuranceCRUDWindow createWindow(Party customer, Party patient) {
        LocalContext context = new LocalContext();
        context.setCustomer(customer);
        context.setPatient(patient);
        return new InsuranceCRUDWindow((Context)context, new HelpContext("foo", null));
    }
}

