/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Assert;
import org.openvpms.paymentprocessor.processor.TransactionMode;
import org.openvpms.paymentprocessor.service.PaymentCapabilities;
import org.openvpms.paymentprocessor.service.PaymentCapabilitiesBuilder;
import org.openvpms.paymentprocessor.service.PaymentProcessorService;
import org.openvpms.paymentprocessor.service.PaymentRequirements;
import org.openvpms.paymentprocessor.service.RefundCapabilities;
import org.openvpms.paymentprocessor.service.RefundCapabilitiesBuilder;
import org.openvpms.paymentprocessor.service.RefundRequirements;
import org.openvpms.paymentprocessor.service.TransactionRequirements;
import org.openvpms.paymentprocessor.service.ValidationStatus;
import org.openvpms.paymentprocessor.transaction.Payment;
import org.openvpms.paymentprocessor.transaction.Refund;
import org.openvpms.paymentprocessor.transaction.Transaction;

public class TestPaymentProcessorService
implements PaymentProcessorService {
    private final PaymentCapabilities paymentCapabilities;
    private final RefundCapabilities refundCapabilities;
    private Consumer<Transaction> submitCallback;
    private Consumer<Transaction> cancelCallback;
    private Function<Transaction, Boolean> checkCallback;

    public TestPaymentProcessorService() {
        this(true);
    }

    public TestPaymentProcessorService(boolean supportsUnmatchedRefunds) {
        PaymentRequirements paymentRequirements = PaymentRequirements.newRequirements().build();
        this.paymentCapabilities = ((PaymentCapabilitiesBuilder)PaymentCapabilities.newCapabilities().add(TransactionMode.LINK, (TransactionRequirements)paymentRequirements)).build();
        RefundRequirements refundRequirements = RefundRequirements.newRequirements().supportsUnmatchedRefunds(supportsUnmatchedRefunds).build();
        this.refundCapabilities = ((RefundCapabilitiesBuilder)RefundCapabilities.newCapabilities().add(TransactionMode.LINK, (TransactionRequirements)refundRequirements)).build();
    }

    public TestPaymentProcessorService(PaymentRequirements paymentRequirements, RefundRequirements refundRequirements) {
        this.paymentCapabilities = ((PaymentCapabilitiesBuilder)PaymentCapabilities.newCapabilities().add(TransactionMode.LINK, (TransactionRequirements)paymentRequirements)).build();
        this.refundCapabilities = ((RefundCapabilitiesBuilder)RefundCapabilities.newCapabilities().add(TransactionMode.LINK, (TransactionRequirements)refundRequirements)).build();
    }

    public String getName() {
        return "Test Payment Processor Service";
    }

    public String getArchetype() {
        return "entity.paymentProcessorTest";
    }

    public PaymentCapabilities getPaymentCapabilities() {
        return this.paymentCapabilities;
    }

    public RefundCapabilities getRefundCapabilities() {
        return this.refundCapabilities;
    }

    public ValidationStatus prepare(Payment payment) {
        return ValidationStatus.valid();
    }

    public void submit(Payment payment, boolean isNew) {
        this.submitTransaction((Transaction)payment);
    }

    public boolean check(Payment payment) {
        return this.checkTransaction((Transaction)payment);
    }

    public void cancel(Payment payment) {
        this.cancelTransaction((Transaction)payment);
    }

    public ValidationStatus prepare(Refund refund) {
        return ValidationStatus.valid();
    }

    public void submit(Refund refund, boolean isNew) {
        this.submitTransaction((Transaction)refund);
    }

    public boolean check(Refund refund) {
        return this.checkTransaction((Transaction)refund);
    }

    public void cancel(Refund refund) {
        this.cancelTransaction((Transaction)refund);
    }

    public void setSubmitCallback(Consumer<Transaction> callback) {
        this.submitCallback = callback;
    }

    public void setCheckCallback(Function<Transaction, Boolean> callback) {
        this.checkCallback = callback;
    }

    public void setCancelCallback(Consumer<Transaction> callback) {
        this.cancelCallback = callback;
    }

    private void submitTransaction(Transaction transaction) {
        Assert.assertEquals((Object)Transaction.Status.IN_PROGRESS, (Object)transaction.getStatus());
        if (this.submitCallback != null) {
            this.submitCallback.accept(transaction);
        } else {
            transaction.setStatus(Transaction.Status.SUBMITTED, "Transaction submitted.");
        }
    }

    private boolean checkTransaction(Transaction transaction) {
        boolean result = false;
        if (this.checkCallback != null) {
            result = this.checkCallback.apply(transaction);
        }
        return result;
    }

    private void cancelTransaction(Transaction transaction) {
        if (this.cancelCallback != null) {
            this.cancelCallback.accept(transaction);
        } else {
            transaction.setStatus(Transaction.Status.CANCELLED, "Transaction cancelled.");
        }
    }
}

