/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.info;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.openvpms.web.workspace.customer.info.InformationWorkspace;
import org.springframework.beans.factory.annotation.Autowired;

public class InformationWorkspaceTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;

    @Test
    public void testSetObject() {
        LocalContext context = new LocalContext();
        TestWorkspace workspace = new TestWorkspace((Context)context);
        Party customer1 = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(customer1);
        context.setCustomer(customer1);
        context.setPatient(patient1);
        Party customer2 = this.customerFactory.createCustomer();
        workspace.setObject(customer2);
        Assert.assertEquals((Object)customer2, (Object)workspace.getObject());
        Assert.assertEquals((Object)customer2, (Object)context.getCustomer());
        Assert.assertNull((Object)context.getPatient());
    }

    @Test
    public void testCancelEditForUnsavedObject() {
        LocalContext context = new LocalContext();
        TestWorkspace workspace = new TestWorkspace((Context)context);
        Party customer = this.customerFactory.createCustomer();
        workspace.setObject(customer);
        CRUDWindow<Party> window = workspace.getCRUDWindow();
        Assert.assertEquals((Object)customer, (Object)window.getObject());
        window.create();
        EditDialog dialog = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog);
        Assert.assertTrue((boolean)dialog.getEditor().getObject().isA("party.customerperson"));
        Assert.assertEquals((Object)customer, (Object)window.getObject());
        Assert.assertEquals((Object)customer, (Object)workspace.getObject());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"cancel");
        Assert.assertNull((Object)window.getObject());
        Assert.assertNull((Object)workspace.getObject());
    }

    @Test
    public void testCancelEditForSavedObject() {
        LocalContext context = new LocalContext();
        TestWorkspace workspace = new TestWorkspace((Context)context);
        Party customer = this.customerFactory.createCustomer("J", "Smith");
        workspace.setObject(customer);
        CRUDWindow<Party> window = workspace.getCRUDWindow();
        window.edit();
        EditDialog dialog = EchoTestHelper.findEditDialog();
        Assert.assertNotNull((Object)dialog);
        Assert.assertTrue((boolean)dialog.getEditor().getObject().isA("party.customerperson"));
        dialog.getEditor().getProperty("lastName").setValue((Object)"Smith");
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"apply");
        dialog.getEditor().getProperty("lastName").setValue((Object)"Jones");
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, (String)"cancel");
        Assert.assertEquals((Object)customer, (Object)workspace.getObject());
        Assert.assertEquals((Object)"Smith,J", (Object)((Party)workspace.getObject()).getName());
    }

    private static class TestWorkspace
    extends InformationWorkspace {
        public TestWorkspace(Context context) {
            super(context, (Preferences)Mockito.mock(Preferences.class));
        }

        public CRUDWindow<Party> getCRUDWindow() {
            return super.getCRUDWindow();
        }
    }
}

