/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.openvpms.archetype.rules.finance.invoice.ChargeItemEventLinker;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemVerifier;
import org.openvpms.archetype.test.builder.hl7.TestHL7Factory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.MapIMObjectCache;
import org.openvpms.hl7.impl.LaboratoriesImpl;
import org.openvpms.hl7.impl.PharmaciesImpl;
import org.openvpms.hl7.io.Connectors;
import org.openvpms.hl7.laboratory.Laboratories;
import org.openvpms.hl7.laboratory.LaboratoryOrderService;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.hl7.patient.PatientEventServices;
import org.openvpms.hl7.patient.PatientInformationService;
import org.openvpms.hl7.pharmacy.Pharmacies;
import org.openvpms.hl7.pharmacy.PharmacyOrderService;
import org.openvpms.laboratory.internal.dispatcher.OrderDispatcher;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.charge.CustomerChargeTestHelper;
import org.openvpms.web.workspace.customer.charge.OrderPlacer;
import org.openvpms.web.workspace.customer.charge.OrderServices;
import org.openvpms.web.workspace.customer.charge.TestLaboratoryOrderService;
import org.openvpms.web.workspace.customer.charge.TestPharmacyOrderService;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderPlacerTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private MedicalRecordRules medicalRecordRules;
    @Autowired
    private PatientContextFactory patientContextFactory;
    @Autowired
    private TestHL7Factory hl7Factory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private PracticeRules practiceRules;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party patient;
    private Party location;
    private User clinician;
    private Entity pharmacy;
    private Entity laboratory;
    private TestPharmacyOrderService pharmacyOrderService;
    private TestLaboratoryOrderService laboratoryOrderService;
    private OrderPlacer placer;
    private PatientInformationService informationService;

    @Before
    public void setUp() {
        super.setUp();
        Party customer = (Party)this.customerFactory.newCustomer().build(false);
        this.patient = this.patientFactory.createPatient();
        this.location = this.practiceFactory.createLocation();
        this.clinician = this.userFactory.createClinician();
        User user = this.userFactory.createUser();
        this.pharmacy = this.hl7Factory.createHL7Pharmacy(this.location, this.userFactory.createUser());
        this.laboratory = CustomerChargeTestHelper.createHL7Laboratory(this.location);
        this.pharmacyOrderService = new TestPharmacyOrderService();
        this.laboratoryOrderService = new TestLaboratoryOrderService();
        Connectors connectors = (Connectors)Mockito.mock(Connectors.class);
        PatientEventServices patientEventServices = (PatientEventServices)Mockito.mock(PatientEventServices.class);
        PharmaciesImpl pharmacies = new PharmaciesImpl(this.getArchetypeService(), connectors, patientEventServices);
        LaboratoriesImpl laboratories = new LaboratoriesImpl(this.getArchetypeService(), connectors, patientEventServices);
        this.informationService = (PatientInformationService)Mockito.mock(PatientInformationService.class);
        MapIMObjectCache cache = new MapIMObjectCache((ArchetypeService)this.getArchetypeService());
        OrderDispatcher dispatcher = (OrderDispatcher)Mockito.mock(OrderDispatcher.class);
        Party practice = this.practiceFactory.getPractice();
        LaboratoryServices laboratoryServices = (LaboratoryServices)Mockito.mock(LaboratoryServices.class);
        Mockito.when((Object)laboratoryServices.getLaboratory((Entity)Mockito.any(), (Party)ArgumentMatchers.eq((Object)this.location))).thenReturn((Object)this.laboratory);
        OrderServices services = new OrderServices((PharmacyOrderService)this.pharmacyOrderService, (Pharmacies)pharmacies, (LaboratoryOrderService)this.laboratoryOrderService, (Laboratories)laboratories, laboratoryServices, dispatcher, this.patientContextFactory, this.informationService, this.medicalRecordRules, this.practiceRules);
        this.placer = new OrderPlacer(customer, this.location, user, practice, (IMObjectCache)cache, services, (ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testPharmacyOrder() {
        Entity productType = this.createProductType(this.pharmacy);
        Product product1 = this.createPharmacyProduct(this.pharmacy);
        Product product2 = this.productFactory.createMedication(productType);
        Product product3 = this.productFactory.createMedication();
        Act visit = this.createVisit(this.patient);
        FinancialAct item1 = this.createItem(product1, BigDecimal.ONE, visit);
        FinancialAct item2 = this.createItem(product2, BigDecimal.TEN, visit);
        FinancialAct item3 = this.createItem(product3, BigDecimal.valueOf(2L), visit);
        IArchetypeService service = this.getArchetypeService();
        TestInvoiceItemVerifier verifier1 = this.getVerifier((Act)item1);
        TestInvoiceItemVerifier verifier2 = this.getVerifier((Act)item2);
        TestInvoiceItemVerifier verifier3 = this.getVerifier((Act)item3);
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)service);
        this.placer.order(Arrays.asList(item1, item2, item3), changes);
        List<TestPharmacyOrderService.Order> orders = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)2L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product1, BigDecimal.ONE, item1.getId(), item1.getActivityStartTime(), this.clinician, this.pharmacy);
        CustomerChargeTestHelper.checkOrder(orders.get(1), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product2, BigDecimal.TEN, item2.getId(), item2.getActivityStartTime(), this.clinician, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)0))).updated((PatientContext)Mockito.any());
        this.verifyOrderStatus(item1, verifier1, "ORDERED");
        this.verifyOrderStatus(item2, verifier2, "ORDERED");
        this.verifyOrderStatus(item3, verifier3, null);
    }

    @Test
    public void testPharmacyOrderWithoutInitialVisit() {
        Product product1 = this.createPharmacyProduct(this.pharmacy);
        FinancialAct item1 = this.createItem(product1, BigDecimal.ONE);
        IArchetypeService service = this.getArchetypeService();
        this.placer.initialise((Act)item1);
        this.placer.order(Collections.singletonList(item1), new PatientHistoryChanges(this.location, (ArchetypeService)service));
        Assert.assertEquals((long)0L, (long)this.pharmacyOrderService.getOrders().size());
        Act visit = this.createVisit(this.patient);
        this.addChargeItem(visit, item1);
        TestInvoiceItemVerifier verifier1 = this.getVerifier((Act)item1);
        this.placer.order(Collections.singletonList(item1), new PatientHistoryChanges(this.location, (ArchetypeService)service));
        List<TestPharmacyOrderService.Order> orders = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product1, BigDecimal.ONE, item1.getId(), item1.getActivityStartTime(), this.clinician, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)0))).updated((PatientContext)Mockito.any());
        this.verifyOrderStatus(item1, verifier1, "ORDERED");
    }

    @Test
    public void testUpdatePharmacyOrderWithoutInitialVisit() {
        Product product1 = this.createPharmacyProduct(this.pharmacy);
        FinancialAct item1 = this.createItem(product1, BigDecimal.ONE);
        IArchetypeService service = this.getArchetypeService();
        this.placer.initialise((Act)item1);
        this.placer.order(Collections.singletonList(item1), new PatientHistoryChanges(this.location, (ArchetypeService)service));
        Assert.assertEquals((long)0L, (long)this.pharmacyOrderService.getOrders().size());
        Act visit = this.createVisit(this.patient);
        ((TestInvoiceItemBuilder)this.accountFactory.updateInvoiceItem(item1).quantity(10)).visit(visit).build();
        TestInvoiceItemVerifier verifier1 = this.getVerifier((Act)item1);
        this.placer.order(Collections.singletonList(item1), new PatientHistoryChanges(this.location, (ArchetypeService)service));
        List<TestPharmacyOrderService.Order> orders = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product1, BigDecimal.TEN, item1.getId(), item1.getActivityStartTime(), this.clinician, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)0))).updated((PatientContext)Mockito.any());
        this.verifyOrderStatus(item1, verifier1, "ORDERED");
    }

    @Test
    public void testLaboratoryOrder() {
        Entity investigationType = this.laboratoryFactory.createInvestigationType(this.laboratory);
        Entity test = this.laboratoryFactory.createHL7Test(investigationType);
        Product product = this.createLaboratoryProduct(test);
        Act visit = this.createVisit(this.patient);
        FinancialAct item1 = this.createItem(product, BigDecimal.ONE, visit);
        DocumentAct investigation = this.createInvestigation(test, investigationType, visit);
        this.accountFactory.updateInvoiceItem(item1).addInvestigation(investigation).build();
        Assert.assertEquals((Object)"PENDING", (Object)investigation.getStatus2());
        TestInvoiceItemVerifier verifier = this.getVerifier((Act)item1);
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService());
        this.placer.order(Arrays.asList(item1, investigation), changes);
        List<TestLaboratoryOrderService.LabOrder> orders = this.laboratoryOrderService.getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestLaboratoryOrderService.LabOrder.Type.CREATE, this.patient, investigation.getId(), investigation.getActivityStartTime(), this.clinician, this.laboratory);
        Assert.assertEquals((Object)"SENT", (Object)investigation.getStatus2());
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)0))).updated((PatientContext)Mockito.any());
        this.verifyOrderStatus(item1, verifier, "ORDERED");
    }

    @Test
    public void testChangeQuantity() {
        Product product = this.createPharmacyProduct(this.pharmacy);
        Act visit = this.createVisit(this.patient);
        FinancialAct item = this.createItem(product, BigDecimal.ONE, visit);
        item.setStatus("ORDERED");
        this.placer.initialise((Act)item);
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService());
        item.setQuantity(BigDecimal.TEN);
        TestInvoiceItemVerifier verifier = this.getVerifier((Act)item);
        this.placer.order(Collections.singletonList(item), changes);
        List<TestPharmacyOrderService.Order> orders = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.UPDATE, this.patient, product, BigDecimal.TEN, item.getId(), item.getActivityStartTime(), this.clinician, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)0))).updated((PatientContext)Mockito.any());
        this.verifyOrderStatus(item, verifier, "ORDERED");
    }

    @Test
    public void testChangePatient() {
        Product product = this.createPharmacyProduct(this.pharmacy);
        Act visit1 = this.createVisit(this.patient);
        FinancialAct item = this.createItem(product, BigDecimal.ONE, visit1);
        item.setStatus("ORDERED");
        Party patient2 = this.patientFactory.createPatient();
        List<FinancialAct> items = Collections.singletonList(item);
        this.placer.initialise((Act)item);
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService());
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setTarget("patient", (IMObject)patient2);
        Act visit2 = this.createVisit(patient2);
        this.addChargeItem(visit2, item);
        try {
            this.placer.order(items, changes);
            Assert.fail((String)"Expected to order() to fail");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)("Patient cannot be changed on order: previous=" + OrderPlacer.toString((IMObject)this.patient) + ", current=" + OrderPlacer.toString((IMObject)patient2)), (Object)expected.getMessage());
        }
    }

    @Test
    public void testChangeProduct() {
        Product product1 = this.createPharmacyProduct(this.pharmacy);
        Product product2 = this.createPharmacyProduct(this.pharmacy);
        Act visit = this.createVisit(this.patient);
        FinancialAct item = this.createItem(product1, BigDecimal.ONE, visit);
        item.setStatus("ORDERED");
        List<FinancialAct> items = Collections.singletonList(item);
        this.placer.initialise((Act)item);
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService());
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setTarget("product", (IMObject)product2);
        try {
            this.placer.order(items, changes);
            Assert.fail((String)"Expected order() to fail");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)("Product cannot be changed on order: previous=" + OrderPlacer.toString((IMObject)product1) + ", current=" + OrderPlacer.toString((IMObject)product2)), (Object)expected.getMessage());
        }
    }

    @Test
    public void testChangeProductToNonPharmacyProduct() {
        Product product1 = this.createPharmacyProduct(this.pharmacy);
        Product product2 = this.productFactory.createMedication();
        Act visit = this.createVisit(this.patient);
        FinancialAct item = this.createItem(product1, BigDecimal.ONE, visit);
        item.setStatus("ORDERED");
        List<FinancialAct> items = Collections.singletonList(item);
        this.placer.initialise((Act)item);
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService());
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setTarget("product", (IMObject)product2);
        TestInvoiceItemVerifier verifier = this.getVerifier((Act)item);
        this.placer.order(items, changes);
        List<TestPharmacyOrderService.Order> orders = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CANCEL, this.patient, product1, BigDecimal.ONE, item.getId(), item.getActivityStartTime(), this.clinician, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)0))).updated((PatientContext)Mockito.any());
        this.verifyOrderStatus(item, verifier, "ORDERED");
    }

    @Test
    public void testChangeClinician() {
        Product product = this.createPharmacyProduct(this.pharmacy);
        User clinician2 = this.userFactory.createClinician();
        Act event = this.createVisit(this.patient);
        FinancialAct item = this.createItem(product, BigDecimal.ONE, event);
        List<FinancialAct> items = Collections.singletonList(item);
        this.placer.initialise((Act)item);
        this.placer.order(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        List<TestPharmacyOrderService.Order> orders1 = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)1L, (long)orders1.size());
        CustomerChargeTestHelper.checkOrder(orders1.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product, BigDecimal.ONE, item.getId(), item.getActivityStartTime(), this.clinician, this.pharmacy);
        this.pharmacyOrderService.clear();
        ((TestInvoiceItemBuilder)this.accountFactory.updateInvoiceItem(item).clinician(clinician2)).build();
        this.placer.order(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        List<TestPharmacyOrderService.Order> orders2 = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)1L, (long)orders2.size());
        CustomerChargeTestHelper.checkOrder(orders2.get(0), TestPharmacyOrderService.Order.Type.UPDATE, this.patient, product, BigDecimal.ONE, item.getId(), item.getActivityStartTime(), clinician2, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)0))).updated((PatientContext)Mockito.any());
    }

    @Test
    public void testOrderWithCancel() {
        Product product1 = this.createPharmacyProduct(this.pharmacy);
        Product product2 = this.createPharmacyProduct(this.pharmacy);
        Act event = this.createVisit(this.patient);
        FinancialAct item1 = this.createItem(product1, BigDecimal.ONE, event);
        FinancialAct item2 = this.createItem(product2, BigDecimal.TEN, event);
        this.placer.initialise((Act)item1);
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService());
        this.placer.order(Collections.singletonList(item2), changes);
        List<TestPharmacyOrderService.Order> orders = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)2L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product2, BigDecimal.TEN, item2.getId(), item2.getActivityStartTime(), this.clinician, this.pharmacy);
        CustomerChargeTestHelper.checkOrder(orders.get(1), TestPharmacyOrderService.Order.Type.CANCEL, this.patient, product1, BigDecimal.ONE, item1.getId(), item1.getActivityStartTime(), this.clinician, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)0))).updated((PatientContext)Mockito.any());
    }

    @Test
    public void testCancel() {
        Product product1 = this.createPharmacyProduct(this.pharmacy);
        Product product2 = this.createPharmacyProduct(this.pharmacy);
        Product product3 = this.productFactory.createMedication();
        Act event = this.createVisit(this.patient);
        FinancialAct item1 = this.createItem(product1, BigDecimal.ONE, event);
        FinancialAct item2 = this.createItem(product2, BigDecimal.TEN, event);
        FinancialAct item3 = this.createItem(product3, BigDecimal.valueOf(2L), event);
        List<Act> items = Arrays.asList(item1, item2, item3);
        for (Act item : items) {
            this.placer.initialise(item);
        }
        this.placer.order(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        this.pharmacyOrderService.clear();
        this.placer.cancel();
        List<TestPharmacyOrderService.Order> orders = this.pharmacyOrderService.getOrders(true);
        Assert.assertEquals((long)2L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CANCEL, this.patient, product1, BigDecimal.ONE, item1.getId(), item1.getActivityStartTime(), this.clinician, this.pharmacy);
        CustomerChargeTestHelper.checkOrder(orders.get(1), TestPharmacyOrderService.Order.Type.CANCEL, this.patient, product2, BigDecimal.TEN, item2.getId(), item2.getActivityStartTime(), this.clinician, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)0))).updated((PatientContext)Mockito.any());
    }

    @Test
    public void testPatientInformationNotificationForNewEvent() {
        Product product = this.createPharmacyProduct(this.pharmacy);
        FinancialAct item = this.createItem(product, BigDecimal.ONE);
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService());
        ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        linker.prepare(Collections.singletonList(item), changes);
        changes.save();
        this.placer.order(Collections.singletonList(item), changes);
        List<TestPharmacyOrderService.Order> orders = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product, BigDecimal.ONE, item.getId(), item.getActivityStartTime(), this.clinician, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)1))).updated((PatientContext)Mockito.any());
    }

    @Test
    public void testPatientInformationNotificationForCompletedEvent() {
        Product product = this.createPharmacyProduct(this.pharmacy);
        Act event = this.createVisit(this.patient);
        event.setActivityEndTime(new Date());
        this.save((IMObject)event);
        FinancialAct item = this.createItem(product, BigDecimal.ONE);
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService());
        ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        linker.prepare(Collections.singletonList(item), changes);
        changes.save();
        this.placer.order(Collections.singletonList(item), changes);
        List<TestPharmacyOrderService.Order> orders = this.pharmacyOrderService.getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        CustomerChargeTestHelper.checkOrder(orders.get(0), TestPharmacyOrderService.Order.Type.CREATE, this.patient, product, BigDecimal.ONE, item.getId(), item.getActivityStartTime(), this.clinician, this.pharmacy);
        ((PatientInformationService)Mockito.verify((Object)this.informationService, (VerificationMode)Mockito.times((int)1))).updated((PatientContext)Mockito.any());
    }

    private Act createVisit(Party patient) {
        return (Act)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().patient(patient)).clinician(this.clinician)).build();
    }

    private void verifyOrderStatus(FinancialAct item, TestInvoiceItemVerifier verifier, String status) {
        ((TestInvoiceItemVerifier)verifier.status(status)).receivedQuantity(null).returnedQuantity(null).verify((IMObject)item);
    }

    private TestInvoiceItemVerifier getVerifier(Act item) {
        return new TestInvoiceItemVerifier((ArchetypeService)this.getArchetypeService()).initialise(item).ignoreMedication(true);
    }

    private FinancialAct createItem(Product product, BigDecimal quantity, Act event) {
        FinancialAct item = this.createItem(product, quantity);
        this.addChargeItem(event, item);
        return item;
    }

    private DocumentAct createInvestigation(Entity test, Entity investigationType, Act visit) {
        DocumentAct investigation = (DocumentAct)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.patient)).clinician(this.clinician)).investigationType(investigationType).addTests(new Entity[]{test}).build();
        this.patientFactory.updateVisit(visit).addItem((Act)investigation).build();
        return investigation;
    }

    private void addChargeItem(Act event, FinancialAct item) {
        IMObjectBean itemBean = this.getBean((IMObject)item);
        for (IMObject object : itemBean.getValues("event", IMObject.class)) {
            itemBean.removeValue("event", object);
        }
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.addTarget("chargeItems", (IMObject)item, "event");
        this.save((IMObject[])new Act[]{event, item});
    }

    private FinancialAct createItem(Product product, BigDecimal quantity) {
        return (FinancialAct)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)this.accountFactory.newInvoiceItem().patient(this.patient)).product(product)).quantity(quantity)).clinician(this.clinician)).quantity(quantity)).unitPrice(1)).build();
    }

    private Product createPharmacyProduct(Entity pharmacy) {
        return (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().pharmacy(pharmacy)).build();
    }

    private Product createLaboratoryProduct(Entity test) {
        return (Product)((TestServiceProductBuilder)this.productFactory.newService().addTests(new Entity[]{test})).build();
    }

    private Entity createProductType(Entity pharmacy) {
        return (Entity)this.productFactory.newProductType().pharmacy(pharmacy).build();
    }
}

