/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account.payment;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.account.payment.AdminCustomerPaymentEditor;
import org.openvpms.web.workspace.customer.account.payment.AdminPaymentActRelationshipCollectionEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class AdminCustomerPaymentEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private CustomerAccountRules rules;

    @Test
    public void testEditor() {
        Party customer = TestHelper.createCustomer();
        FinancialAct cash = FinancialTestHelper.createPaymentCash((BigDecimal)BigDecimal.ONE);
        FinancialAct eft = FinancialTestHelper.createPaymentEFT((BigDecimal)BigDecimal.TEN);
        List acts = FinancialTestHelper.createPayment((Party)customer, (Entity)TestHelper.createTill(), (String)"POSTED", (FinancialAct[])new FinancialAct[]{cash, eft});
        Date startTime = DateRules.getYesterday();
        ((FinancialAct)acts.get(0)).setActivityStartTime(startTime);
        this.save(acts);
        this.checkEquals(BigDecimal.valueOf(-11L), this.rules.getBalance(customer));
        TestAdminCustomerPaymentEditor editor = new TestAdminCustomerPaymentEditor((FinancialAct)acts.get(0), null, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        editor.getComponent();
        EditorTestHelper.assertValid((Modifiable)editor);
        AdminPaymentActRelationshipCollectionEditor items = editor.getItems();
        FinancialAct currentCash = this.getAct("act.customerAccountPaymentCash", items.getCurrentActs());
        items.change(currentCash, "act.customerAccountPaymentCredit");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkEquals(BigDecimal.valueOf(-11L), this.rules.getBalance(customer));
        Assert.assertNull((Object)this.get((IMObject)cash));
        FinancialAct payment = (FinancialAct)this.get((IMObject)acts.get(0));
        Assert.assertNotNull((Object)payment);
        Assert.assertEquals((Object)startTime, (Object)payment.getActivityStartTime());
        this.checkEquals(BigDecimal.valueOf(11L), payment.getTotal());
        this.checkItem(payment, "act.customerAccountPaymentCredit", BigDecimal.ONE);
        this.checkItem(payment, "act.customerAccountPaymentEFT", BigDecimal.TEN);
        IMObjectBean bean = this.getBean((IMObject)payment);
        String audit = bean.getString("audit");
        Assert.assertNotNull((Object)audit);
        Assert.assertTrue((boolean)audit.matches(".*Cash.*Credit Card"));
    }

    @Test
    public void testInvalidAct() {
        Party customer = TestHelper.createCustomer();
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)customer, (Entity)TestHelper.createTill(), (String)"POSTED");
        this.checkInvalidAct(payment);
        payment.setStatus("IN_PROGRESS");
        this.save((IMObject)payment);
        this.checkInvalidAct(payment);
    }

    @Test
    public void testValidation() {
        Party customer = TestHelper.createCustomer();
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)customer, (Entity)TestHelper.createTill(), (String)"POSTED");
        this.save((IMObject)payment);
        IMObjectBean bean = this.getBean((IMObject)payment);
        FinancialAct tillBalance = (FinancialAct)bean.getSource("tillBalance", FinancialAct.class);
        Assert.assertEquals((Object)"UNCLEARED", (Object)tillBalance.getStatus());
        AdminCustomerPaymentEditor editor = new AdminCustomerPaymentEditor(payment, null, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)editor.validate((Validator)new DefaultValidator()));
        tillBalance.setStatus("IN_PROGRESS");
        this.save((IMObject)tillBalance);
        editor.resetValid();
        Assert.assertTrue((boolean)editor.validate((Validator)new DefaultValidator()));
        tillBalance.setStatus("CLEARED");
        this.save((IMObject)tillBalance);
        editor.resetValid();
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"This payment cannot be edited as it linked to a Cleared Till Balance");
    }

    @Test
    public void testInvariants() {
        Party customer = TestHelper.createCustomer();
        FinancialAct payment = FinancialTestHelper.createPayment((BigDecimal)BigDecimal.TEN, (Party)customer, (Entity)TestHelper.createTill(), (String)"POSTED");
        this.save((IMObject)payment);
        AdminCustomerPaymentEditor editor = new AdminCustomerPaymentEditor(payment, null, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)editor.validate((Validator)new DefaultValidator()));
        editor.getProperty("amount").setValue((Object)BigDecimal.ONE);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"The total must be $10.00");
        editor.getProperty("amount").setValue((Object)BigDecimal.TEN);
        Assert.assertTrue((boolean)editor.validate((Validator)new DefaultValidator()));
        editor.setStatus("IN_PROGRESS");
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Status must be POSTED");
    }

    @Test
    public void checkCannotChangeEFTWithTransactions() {
        Party customer = TestHelper.createCustomer();
        Entity terminal = this.practiceFactory.createEFTPOSTerminal();
        FinancialAct transaction = (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(customer)).amount(BigDecimal.TEN)).terminal(terminal)).location(this.practiceFactory.createLocation())).status("APPROVED")).build();
        FinancialAct item1 = (FinancialAct)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().amount(BigDecimal.TEN)).build(false);
        FinancialAct item2 = (FinancialAct)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().addTransaction(transaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(customer)).till(this.practiceFactory.createTill())).add(new FinancialAct[]{item1, item2})).status("POSTED")).build();
        this.checkEquals(BigDecimal.valueOf(-20L), this.rules.getBalance(customer));
        TestAdminCustomerPaymentEditor editor = new TestAdminCustomerPaymentEditor(payment, null, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        editor.getComponent();
        EditorTestHelper.assertValid((Modifiable)editor);
        AdminPaymentActRelationshipCollectionEditor items = editor.getItems();
        items.change(item1, "act.customerAccountPaymentCredit");
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertNull((Object)this.get((IMObject)item1));
        this.checkEquals(BigDecimal.valueOf(-20L), this.rules.getBalance(customer));
        IMObjectBean bean = this.getBean((IMObject)payment);
        String audit = bean.getString("audit");
        Assert.assertNotNull((Object)audit);
        Assert.assertTrue((boolean)audit.matches(".*EFT.*Credit Card"));
        try {
            items.change(item2, "act.customerAccountPaymentCredit");
            Assert.fail((String)"Expected change to fail");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void checkItem(FinancialAct payment, String archetype, BigDecimal total) {
        IMObjectBean bean = this.getBean((IMObject)payment);
        FinancialAct item = (FinancialAct)bean.getTarget("items", FinancialAct.class, Policies.any((Predicate)Predicates.targetIsA((String[])new String[]{archetype})));
        Assert.assertNotNull((Object)item);
        this.checkEquals(total, item.getTotal());
    }

    private void checkInvalidAct(FinancialAct act) {
        try {
            new AdminCustomerPaymentEditor(act, null, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
            Assert.fail((String)"Expected constructor to fail");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertEquals((Object)"Argument 'act' must be saved and have POSTED status", (Object)expected.getMessage());
        }
    }

    private FinancialAct getAct(String archetype, Collection<? extends IMObject> acts) {
        FinancialAct result = acts.stream().filter(act -> act.isA(archetype)).findFirst().orElse(null);
        Assert.assertNotNull((Object)result);
        return result;
    }

    private static class TestAdminCustomerPaymentEditor
    extends AdminCustomerPaymentEditor {
        public TestAdminCustomerPaymentEditor(FinancialAct act, IMObject parent, LayoutContext context) {
            super(act, parent, context);
        }

        public AdminPaymentActRelationshipCollectionEditor getItems() {
            return (AdminPaymentActRelationshipCollectionEditor)super.getItems();
        }
    }
}

