/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.party.TestContactFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.supplier.TestVetBuilder;
import org.openvpms.archetype.test.builder.supplier.TestVetPracticeBuilder;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.AbstractMailContextTest;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerMailContextTestCase
extends AbstractMailContextTest {
    @Autowired
    private TestContactFactory contactFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;

    @Test
    public void testCustomerToAddresses() {
        LocalContext context = new LocalContext();
        CustomerMailContext mailContext = new CustomerMailContext((Context)context, true);
        Assert.assertNull((Object)mailContext.getCustomer());
        this.checkAddresses(mailContext.getToAddresses(), null, new Contact[0]);
        Contact contact1A = this.contactFactory.createEmail("customer1@gmail.com", true, new String[0]);
        Contact contact1B = this.contactFactory.createEmail("customer1@outlook.com", new String[0]);
        Party customer1 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContacts(new Contact[]{contact1A, contact1B})).build();
        Party customer2 = this.customerFactory.createCustomer();
        Contact contact3 = this.contactFactory.createEmail("customer3@gmail.com", new String[0]);
        Party customer3 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContacts(new Contact[]{contact3})).build();
        context.setCustomer(customer1);
        Assert.assertEquals((Object)customer1, (Object)mailContext.getCustomer());
        this.checkAddresses(mailContext.getToAddresses(), contact1A, contact1A, contact1B);
        context.setCustomer(customer2);
        this.checkAddresses(mailContext.getToAddresses(), null, new Contact[0]);
        context.setCustomer(customer3);
        this.checkAddresses(mailContext.getToAddresses(), contact3, contact3);
    }

    @Test
    public void testUpdateCustomer() {
        LocalContext context = new LocalContext();
        CustomerMailContext mailContext = new CustomerMailContext((Context)context, true);
        Assert.assertNull((Object)mailContext.getCustomer());
        this.checkAddresses(mailContext.getToAddresses(), null, new Contact[0]);
        Contact contactA = this.contactFactory.createEmail("customer1@gmail.com", new String[0]);
        Contact contactB = this.contactFactory.createEmail("customer1@outlook.com", true, new String[0]);
        Party customer1 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContacts(new Contact[]{contactA})).build();
        context.setCustomer(customer1);
        this.checkAddresses(mailContext.getToAddresses(), contactA, contactA);
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(customer1).addContacts(new Contact[]{contactB})).build();
        this.checkAddresses(mailContext.getToAddresses(), contactB, contactA, contactB);
    }

    @Test
    public void testPatientReferralAddresses() {
        LocalContext context = new LocalContext();
        CustomerMailContext mailContext = new CustomerMailContext((Context)context, true);
        Assert.assertNull((Object)mailContext.getCustomer());
        Assert.assertNull((Object)mailContext.getPatient());
        this.checkAddresses(mailContext.getToAddresses(), null, new Contact[0]);
        Contact vet1Contact = this.contactFactory.createEmail("vet1@vetsrus.com", new String[0]);
        Party vet1 = (Party)((TestVetBuilder)this.supplierFactory.newVet().addContacts(new Contact[]{vet1Contact})).build();
        Contact vetPracticeContact = this.contactFactory.createEmail("pactice@vetsrus.com", new String[0]);
        Party vet2 = this.supplierFactory.createVet();
        ((TestVetPracticeBuilder)this.supplierFactory.newVetPractice().addVets(new Party[]{vet1, vet2}).addContact(vetPracticeContact)).build();
        Contact contact1A = this.contactFactory.createEmail("customer1@gmail.com", true, new String[0]);
        Contact contact1B = this.contactFactory.createEmail("customer1@outlook.com", new String[0]);
        Party customer1 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContacts(new Contact[]{contact1A, contact1B})).build();
        Party patient1 = (Party)this.patientFactory.newPatient().owner(customer1).addReferredFrom(vet1).build();
        Party patient2 = (Party)this.patientFactory.newPatient().owner(customer1).addReferredFrom(vet2).build();
        context.setCustomer(customer1);
        context.setPatient(patient1);
        this.checkAddresses(mailContext.getToAddresses(), contact1A, contact1A, contact1B, vet1Contact, vetPracticeContact);
        context.setPatient(patient2);
        this.checkAddresses(mailContext.getToAddresses(), contact1A, contact1A, contact1B, vetPracticeContact);
    }

    @Test
    public void testUpdatePatient() {
        LocalContext context = new LocalContext();
        CustomerMailContext mailContext = new CustomerMailContext((Context)context, true);
        Assert.assertNull((Object)mailContext.getCustomer());
        Assert.assertNull((Object)mailContext.getPatient());
        this.checkAddresses(mailContext.getToAddresses(), null, new Contact[0]);
        Contact vetContact = this.contactFactory.createEmail("vet1@vetsrus.com", new String[0]);
        Party vet = (Party)((TestVetBuilder)this.supplierFactory.newVet().addContacts(new Contact[]{vetContact})).build();
        Contact vetPracticeContact = this.contactFactory.createEmail("pactice@vetsrus.com", new String[0]);
        ((TestVetPracticeBuilder)this.supplierFactory.newVetPractice().addVets(new Party[]{vet}).addContact(vetPracticeContact)).build();
        Contact customerContact = this.contactFactory.createEmail("customer@gmail.com", new String[0]);
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContacts(new Contact[]{customerContact})).build();
        Party patient = (Party)this.patientFactory.newPatient().owner(customer).build();
        context.setCustomer(customer);
        context.setPatient(patient);
        this.checkAddresses(mailContext.getToAddresses(), customerContact, customerContact);
        this.patientFactory.updatePatient(patient).addReferredTo(vet).build();
        this.checkAddresses(mailContext.getToAddresses(), customerContact, customerContact, vetContact, vetPracticeContact);
    }
}

