/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.party.TestEmailContactBuilder;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.customer.BillingCustomerMailContext;
import org.springframework.beans.factory.annotation.Autowired;

public class BillingCustomerMailContextTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testFromAddress() {
        Party practice = (Party)((TestPracticeBuilder)((TestEmailContactBuilder)((TestEmailContactBuilder)((TestPracticeBuilder)((TestEmailContactBuilder)this.practiceFactory.newPractice().newEmail().email("preferred@practice.com").preferred()).add()).newEmail().email("billing@practice.com").preferred(false)).purposes(new String[]{"BILLING"})).add()).build();
        LocalContext context = new LocalContext();
        context.setPractice(practice);
        BillingCustomerMailContext mailContext = new BillingCustomerMailContext((Context)context);
        List fromAddresses1 = mailContext.getFromAddresses();
        Assert.assertEquals((long)2L, (long)fromAddresses1.size());
        this.checkEmail((Contact)fromAddresses1.get(0), "billing@practice.com", false, "BILLING");
        this.checkEmail((Contact)fromAddresses1.get(1), "preferred@practice.com", true);
        Party location = (Party)((TestLocationBuilder)((TestEmailContactBuilder)((TestEmailContactBuilder)((TestLocationBuilder)((TestEmailContactBuilder)this.practiceFactory.newLocation().newEmail().email("location@practice.com").preferred()).add()).newEmail().email("location.billing@practice.com").preferred(false)).purposes(new String[]{"BILLING"})).add()).build();
        context.setLocation(location);
        List fromAddresses2 = mailContext.getFromAddresses();
        Assert.assertEquals((long)2L, (long)fromAddresses2.size());
        this.checkEmail((Contact)fromAddresses2.get(0), "location.billing@practice.com", false, "BILLING");
        this.checkEmail((Contact)fromAddresses2.get(1), "location@practice.com", true);
        ((TestLocationBuilder)((TestEmailContactBuilder)((TestEmailContactBuilder)this.practiceFactory.updateLocation(location).newEmail().email("preferred.billing@practice.com").preferred()).purposes(new String[]{"BILLING"})).add()).build();
        List fromAddresses3 = mailContext.getFromAddresses();
        Assert.assertEquals((long)3L, (long)fromAddresses3.size());
        this.checkEmail((Contact)fromAddresses3.get(0), "preferred.billing@practice.com", true, "BILLING");
        this.checkEmail((Contact)fromAddresses3.get(1), "location@practice.com", true);
        this.checkEmail((Contact)fromAddresses3.get(2), "location.billing@practice.com", false, "BILLING");
    }

    @Test
    public void testToAddress() {
        LocalContext context = new LocalContext();
        BillingCustomerMailContext mailContext = new BillingCustomerMailContext((Context)context);
        MailContext.Addresses toAddresses0 = mailContext.getToAddresses();
        this.checkAddresses(toAddresses0, null, new String[0]);
        Party customer1 = this.customerFactory.createCustomer();
        context.setCustomer(customer1);
        MailContext.Addresses toAddresses1 = mailContext.getToAddresses();
        this.checkAddresses(toAddresses1, null, new String[0]);
        Party customer2 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail("foo@bar.com", new String[0])).build();
        context.setCustomer(customer2);
        MailContext.Addresses toAddresses2 = mailContext.getToAddresses();
        this.checkAddresses(toAddresses2, "foo@bar.com", "foo@bar.com");
        Party customer3 = (Party)((TestCustomerBuilder)((TestEmailContactBuilder)((TestCustomerBuilder)((TestEmailContactBuilder)this.customerFactory.newCustomer().newEmail().email("foo@bar.com").preferred(false)).add()).newEmail().email("bar@foo.com").preferred()).add()).build();
        context.setCustomer(customer3);
        MailContext.Addresses toAddresses3 = mailContext.getToAddresses();
        this.checkAddresses(toAddresses3, "bar@foo.com", "bar@foo.com", "foo@bar.com");
    }

    private void checkEmail(Contact contact, String email, boolean preferred, String ... purposes) {
        Assert.assertTrue((boolean)contact.isA("contact.email"));
        IMObjectBean bean = this.checkEmail(contact, email, preferred);
        List actualPurposes = bean.getValues("purposes", Lookup.class).stream().map(Lookup::getCode).collect(Collectors.toList());
        Assert.assertEquals((long)actualPurposes.size(), (long)purposes.length);
        for (String purpose : purposes) {
            Assert.assertTrue((boolean)actualPurposes.contains(purpose));
        }
    }

    private void checkAddresses(MailContext.Addresses addresses, String preferred, String ... expected) {
        if (preferred != null) {
            Assert.assertNotNull((Object)addresses.getPreferred());
            this.checkEmail(addresses.getPreferred(), preferred, true);
        } else {
            Assert.assertNull((Object)addresses.getPreferred());
        }
        List contacts = addresses.getContacts();
        Assert.assertEquals((long)expected.length, (long)contacts.size());
        for (int i = 0; i < contacts.size(); ++i) {
            Contact contact = (Contact)contacts.get(i);
            this.checkEmail(contact, expected[i], expected[i].equals(preferred));
        }
    }

    private IMObjectBean checkEmail(Contact contact, String email, boolean preferred) {
        IMObjectBean bean = this.getBean((IMObject)contact);
        Assert.assertEquals((Object)email, (Object)bean.getString("emailAddress"));
        Assert.assertEquals((Object)preferred, (Object)bean.getBoolean("preferred"));
        return bean;
    }
}

