/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.type;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.component.business.service.archetype.helper.IMObjectGraph;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.workspace.admin.type.ReminderTypeEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class ReminderTypeEditorTestCase
extends AbstractIMObjectEditorTest<ReminderTypeEditor> {
    @Autowired
    private ReminderRules reminderRules;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestReminderFactory reminderFactory;

    public ReminderTypeEditorTestCase() {
        super(ReminderTypeEditor.class, "entity.reminderType");
    }

    @Test
    public void testCreateFromGraph() {
        Entity template = this.documentFactory.createTemplate("act.patientDocumentForm");
        Entity reminderType = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.YEARS).newCount().count(0).interval(-2, DateUnits.WEEKS).template(template).newRule().print().add().add().newCount().count(1).interval(-1, DateUnits.WEEKS).template(template).newRule().print().add().add().build();
        IMObjectGraph graph = this.reminderRules.copyReminderType(reminderType);
        ReminderTypeEditor editor = new ReminderTypeEditor(graph, this.createLayoutContext());
        editor.getComponent();
        EditorTestHelper.assertValid((Modifiable)editor);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Entity copy = (Entity)this.get(editor.getObject());
        Assert.assertNotNull((Object)copy);
        IMObjectBean bean = this.getBean((IMObject)copy);
        Assert.assertEquals((long)2L, (long)bean.getTargets("counts").size());
    }
}

