/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.RandomUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.test.builder.doc.TestDocumentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestLetterheadBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.template.letterhead.LetterheadEditor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class LetterheadEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private DocumentRules rules;

    @Test
    public void testValidateLogo() throws IOException {
        Entity letterhead = (Entity)this.create("entity.letterhead", Entity.class);
        letterhead.setName("dummy");
        LetterheadEditor editor = (LetterheadEditor)this.createEditor(letterhead);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"One of Logo File or Logo must be supplied");
        Property logoFile = editor.getProperty("logoFile");
        logoFile.setValue((Object)"foo.gif");
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"'foo.gif' does not exist");
        Path file = Files.createTempFile("zz", ".png", new FileAttribute[0]);
        logoFile.setValue((Object)file.toString());
        Assert.assertTrue((boolean)editor.isValid());
        logoFile.setValue(null);
        Assert.assertFalse((boolean)editor.isValid());
        Document logo = (Document)((TestDocumentBuilder)this.documentFactory.newDocument().name(ValueStrategy.suffix((String)".png"))).content(RandomUtils.nextBytes((int)10)).build();
        editor.setLogo(logo);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        DocumentAct act = this.rules.getLogo(letterhead);
        Assert.assertNotNull((Object)act);
        Assert.assertEquals((Object)logo.getObjectReference(), (Object)act.getDocument());
    }

    @Test
    public void testFactory() {
        Entity letterhead = (Entity)this.create("entity.letterhead", Entity.class);
        IMObjectEditor editor = this.createEditor(letterhead);
        Assert.assertTrue((boolean)(editor instanceof LetterheadEditor));
    }

    @Test
    public void testNewInstance() {
        Entity letterhead = (Entity)this.create("entity.letterhead", Entity.class);
        IMObjectEditor editor = this.createEditor(letterhead);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof LetterheadEditor));
        Assert.assertEquals((Object)letterhead, (Object)newInstance.getObject());
    }

    @Test
    public void testDelete() {
        TestLetterheadBuilder builder = this.documentFactory.newLetterhead().logo(this.documentFactory.createJRXML());
        Entity letterhead = (Entity)builder.build();
        DocumentAct logo = builder.getLogo();
        Assert.assertNotNull((Object)logo);
        Assert.assertNotNull((Object)logo.getDocument());
        final IMObjectEditor editor = this.createEditor(letterhead);
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                editor.delete();
            }
        });
        Assert.assertNull((Object)this.get((IMObject)letterhead));
        Assert.assertNull((Object)this.get((IMObject)logo));
        Assert.assertNull((Object)this.get(logo.getDocument()));
    }

    private IMObjectEditor createEditor(Entity letterhead) {
        return this.factory.create((IMObject)letterhead, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
    }
}

