/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.openvpms.web.workspace.admin.system.diagnostics.LogReader;

public class LogReaderTestCase {
    @Rule
    public TemporaryFolder dir = new TemporaryFolder();

    @Test
    public void testEmptyFile() throws IOException {
        File file = this.dir.newFile();
        LogReader reader = new LogReader(file.getPath(), 10);
        LogReader.Page page = reader.read(0);
        Assert.assertEquals((long)0L, (long)page.getLines().size());
        Assert.assertEquals((long)0L, (long)page.getPage());
        Assert.assertEquals((long)0L, (long)page.getFirstLine());
        Assert.assertTrue((boolean)page.isPartial());
    }

    @Test
    public void testSequentialRead() throws IOException {
        File file = this.dir.newFile();
        this.append(file, 42, 1);
        LogReader reader = new LogReader(file, 10);
        LogReader.Page page1 = reader.read(0);
        LogReader.Page page2 = reader.read(1);
        LogReader.Page page3 = reader.read(2);
        LogReader.Page page4 = reader.read(3);
        LogReader.Page page5 = reader.read(4);
        this.checkPage(page1, 0, 10, 0, false);
        this.checkPage(page2, 1, 10, 10, false);
        this.checkPage(page3, 2, 10, 20, false);
        this.checkPage(page4, 3, 10, 30, false);
        this.checkPage(page5, 4, 2, 40, true);
    }

    @Test
    public void testRandomRead() throws IOException {
        File file = this.dir.newFile();
        this.append(file, 43, 1);
        LogReader reader = new LogReader(file, 10);
        LogReader.Page page1 = reader.read(0);
        LogReader.Page page4 = reader.read(3);
        LogReader.Page page2 = reader.read(1);
        LogReader.Page page5 = reader.read(4);
        this.checkPage(page1, 0, 10, 0, false);
        this.checkPage(page4, 3, 10, 30, false);
        this.checkPage(page2, 1, 10, 10, false);
        this.checkPage(page5, 4, 3, 40, true);
        LogReader.Page page6 = reader.read(5);
        Assert.assertNull((Object)page6);
        page5 = reader.read(4);
        this.checkPage(page5, 4, 3, 40, true);
    }

    @Test
    public void testAppend() throws IOException {
        File file = this.dir.newFile();
        this.append(file, 5, 1);
        LogReader reader = new LogReader(file, 10);
        LogReader.Page page1 = reader.read(0);
        this.checkPage(page1, 0, 5, 0, true);
        this.append(file, 12, 6);
        page1 = reader.read(0);
        this.checkPage(page1, 0, 10, 0, false);
        LogReader.Page page2 = reader.read(1);
        this.checkPage(page2, 1, 7, 10, true);
    }

    @Test
    public void testPartialWrite() throws IOException {
        File file = this.dir.newFile();
        this.append(file, 9, 1);
        this.append(file, "10");
        LogReader reader = new LogReader(file, 10);
        LogReader.Page page1 = reader.read(0);
        this.checkPage(page1, 0, 10, 0, true);
        LogReader.Page page2 = reader.read(1);
        Assert.assertNull((Object)page2);
        this.append(file, "\n");
        this.append(file, 2, 11);
        page1 = reader.read(0);
        this.checkPage(page1, 0, 10, 0, false);
        page2 = reader.read(1);
        this.checkPage(page2, 1, 2, 10, true);
    }

    @Test
    public void testReadLast() throws IOException {
        File file = this.dir.newFile();
        LogReader reader = new LogReader(file, 10);
        LogReader.Page page1 = reader.readLast();
        this.checkPage(page1, 0, 0, 0, true);
        this.append(file, 9, 1);
        page1 = reader.readLast();
        this.checkPage(page1, 0, 9, 0, true);
        this.append(file, 12, 10);
        LogReader.Page page3 = reader.readLast();
        this.checkPage(page3, 2, 1, 20, true);
    }

    @Test
    public void testReadLastWithTruncate() throws IOException {
        File file = this.dir.newFile();
        LogReader reader = new LogReader(file, 10);
        this.append(file, 23, 1);
        LogReader.Page last1 = reader.readLast();
        this.checkPage(last1, 2, 3, 20, true);
        this.write(file, 5, 1, false);
        LogReader.Page last2 = reader.readLast();
        Assert.assertNull((Object)last2);
        LogReader.Page last3 = reader.readLast();
        this.checkPage(last3, 0, 5, 0, true);
    }

    @Test
    public void testBinaryData() throws IOException {
        File file = this.dir.newFile();
        DataOutputStream stream = new DataOutputStream(new FileOutputStream(file));
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                stream.write(0);
                stream.write(255);
                stream.write(10);
            }
        }
        stream.close();
        LogReader reader = new LogReader(file, 10);
        LogReader.Page page0 = reader.read(0);
        Assert.assertNotNull((Object)page0);
        Assert.assertEquals((long)0L, (long)page0.getPage());
        List lines = page0.getLines();
        Assert.assertEquals((long)10L, (long)lines.size());
        String expected = "" + '\u0000' + '\u00ff';
        for (String line : lines) {
            Assert.assertEquals((Object)expected, (Object)line);
        }
    }

    private void checkPage(LogReader.Page page, int pageNo, int count, int first, boolean partial) {
        Assert.assertNotNull((Object)page);
        Assert.assertEquals((long)pageNo, (long)page.getPage());
        List lines = page.getLines();
        Assert.assertEquals((long)count, (long)lines.size());
        Assert.assertEquals((long)first, (long)page.getFirstLine());
        Assert.assertEquals((Object)partial, (Object)page.isPartial());
        for (int i = 0; i < lines.size(); ++i) {
            Assert.assertEquals((Object)Integer.toString(first + i + 1), lines.get(i));
        }
    }

    private void append(File file, int lines, int start) throws IOException {
        this.write(file, lines, start, true);
    }

    private void write(File file, int lines, int start, boolean append) throws IOException {
        FileWriter writer = new FileWriter(file, append);
        for (int i = 0; i < lines; ++i) {
            writer.write("" + (i + start) + "\n");
        }
        writer.close();
    }

    private void append(File file, String value) throws IOException {
        FileWriter writer = new FileWriter(file, true);
        writer.write(value);
        writer.close();
    }
}

